/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class StateMatcher {
    public static final StateMatcher EMPTY = new StateMatcher(Blocks.field_150350_a, Collections.emptyMap());
    private static final Pattern STATE_PATTERN = Pattern.compile("^(.*?:[a-z_-]+)(\\[(.*?)])?");
    private static final Object ANY = new Object();
    private final Block block;
    private final Map<IProperty<?>, Object> rules;

    private StateMatcher(Block block, Map<IProperty<?>, Object> rules) {
        this.block = block;
        this.rules = rules;
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    public boolean matches(IBlockState state) {
        if (!this.isPresent()) {
            return false;
        }
        if (state.func_177230_c() != this.block) {
            return false;
        }
        ImmutableMap properties = state.func_177228_b();
        for (Map.Entry<IProperty<?>, Object> e : this.rules.entrySet()) {
            Object value = properties.get(e.getKey());
            if (value != null && (e.getValue() == ANY || e.getValue().equals(value))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<IProperty<?>, Object> e : this.rules.entrySet()) {
            String key = e.getKey().func_177701_a();
            String value = e.getValue() == ANY ? "any" : e.getValue().toString();
            sb.append(sb.length() > 0 ? (char)',' : '{');
            sb.append(key).append("=").append(value);
        }
        sb.append(sb.length() > 0 ? "}" : "");
        return sb.toString();
    }

    public static Block blockFromStringUnchecked(String reference) {
        String name;
        Matcher matcher = STATE_PATTERN.matcher(reference);
        if (matcher.find() && matcher.groupCount() > 0 && (name = matcher.group(1)) != null) {
            return Block.func_149684_b((String)name);
        }
        return Blocks.field_150350_a;
    }

    public static IBlockState stateFromStringUnchecked(String reference) {
        Block block;
        String name;
        Matcher matcher = STATE_PATTERN.matcher(reference);
        if (matcher.find() && (name = matcher.group(1)) != null && (block = Block.func_149684_b((String)name)) != null && block != Blocks.field_150350_a) {
            String properties = matcher.group(3);
            if (properties != null) {
                return StateMatcher.matchState(block, properties);
            }
            return block.func_176223_P();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static IBlockState matchState(Block block, String properties) {
        StateMatcher stateMatcher = StateMatcher.of(block, properties);
        for (IBlockState state : block.func_176194_O().func_177619_a()) {
            if (!stateMatcher.matches(state)) continue;
            return state;
        }
        return block.func_176223_P();
    }

    public static Optional<StateMatcher> of(ResourceLocation location, String rule) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)location);
        if (block == Blocks.field_150350_a) {
            return Optional.empty();
        }
        return Optional.of(StateMatcher.of(block, rule));
    }

    public static StateMatcher of(Block block, String rule) {
        BlockStateContainer container = block.func_176194_O();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!rule.equals("*")) {
            for (int i = 0; i < rule.length(); ++i) {
                String key;
                IProperty property;
                int start = i;
                boolean hasValue = false;
                while (i < rule.length()) {
                    char c = rule.charAt(i);
                    if (c == '=') {
                        hasValue = true;
                        break;
                    }
                    if (c == ',') break;
                    ++i;
                }
                if ((property = container.func_185920_a(key = rule.substring(start, i))) == null) {
                    return EMPTY;
                }
                Object value = ANY;
                if (hasValue) {
                    start = ++i;
                    while (i < rule.length() && rule.charAt(i) != ',') {
                        ++i;
                    }
                    String val = rule.substring(start, i);
                    value = property.func_185929_b(val).orNull();
                    if (value == null) {
                        return EMPTY;
                    }
                }
                builder.put((Object)property, value);
            }
        }
        return new StateMatcher(block, (Map<IProperty<?>, Object>)builder.build());
    }
}

