/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.util;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;

public class ToolHelper {
    private static final ToolHelper INSTANCE = new ToolHelper();
    public static final Set<String> HAND = ImmutableSet.of((Object)"hand");
    private final Map<Class<?>, Set<String>> registry = new HashMap();

    private ToolHelper() {
        this.register(ItemShears.class, "shears");
        this.register(ItemSword.class, "sword");
    }

    public void register(Class<? extends Item> type, String ... tools) {
        this.registry.put(type, (Set<String>)ImmutableSet.copyOf((Object[])tools));
    }

    public Set<String> getTool(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return HAND;
        }
        Item item = stack.func_77973_b();
        if (ItemTool.class.isInstance(item)) {
            return item.getToolClasses(stack);
        }
        return this.registry.getOrDefault(item.getClass(), HAND);
    }

    public String getToolMaterial(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return "";
        }
        Item item = stack.func_77973_b();
        if (ItemTool.class.isInstance(item)) {
            return ((ItemTool)ItemTool.class.cast(item)).func_77861_e().toLowerCase();
        }
        if (ItemHoe.class.isInstance(item)) {
            return ((ItemHoe)ItemHoe.class.cast(item)).func_77842_f().toLowerCase();
        }
        if (ItemSword.class.isInstance(item)) {
            return ((ItemSword)ItemSword.class.cast(item)).func_150932_j().toLowerCase();
        }
        return "";
    }

    public static ToolHelper getInstance() {
        return INSTANCE;
    }
}

