/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.util;

import java.util.NavigableMap;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;

public class WeightedList<T> {
    private final NavigableMap<Double, T> map = new ConcurrentSkipListMap<Double, T>();
    private volatile double total = 0.0;

    public WeightedList<T> add(T t) {
        return this.add(t, 1.0);
    }

    public WeightedList<T> add(T t, double weight) {
        if (weight < 0.0) {
            return this;
        }
        this.map.put(this.total += weight, t);
        return this;
    }

    public T next(Random random) {
        double lookup = random.nextDouble() * this.total;
        return this.map.higherEntry(lookup).getValue();
    }

    public static <T> WeightedList<T> create() {
        return new WeightedList<T>();
    }
}

