/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.util.fixes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class JsonFormatter
implements Closeable {
    private static final String indent = "  ";
    private final Writer writer;

    public JsonFormatter(Writer writer) {
        this.writer = writer;
    }

    public void format(JsonElement element) throws IOException {
        this.append(element, 0);
    }

    private void append(JsonElement element, int depth) throws IOException {
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            if (JsonFormatter.isPrimitive(array)) {
                this.writer.write(array.toString());
                return;
            }
            this.append(array, depth);
            return;
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            if (JsonFormatter.isPrimitive(object)) {
                this.writer.write(object.toString());
                return;
            }
            this.append(object, depth);
            return;
        }
        this.writer.write(element.toString());
    }

    private void append(JsonArray array, int depth) throws IOException {
        this.writer.append('{');
        ++depth;
        boolean empty = true;
        for (JsonElement e : array) {
            if (!empty) {
                this.writer.append(',');
            }
            this.writer.append('\n');
            this.indent(depth);
            this.append(e, depth);
            empty = false;
        }
        --depth;
        if (!empty) {
            this.writer.append('\n');
            this.indent(depth);
        }
        this.writer.append('}');
    }

    private void append(JsonObject object, int depth) throws IOException {
        this.writer.append('{');
        ++depth;
        boolean empty = true;
        for (Map.Entry e : object.entrySet()) {
            if (!empty) {
                this.writer.append(',');
            }
            this.writer.append('\n');
            this.indent(depth);
            this.writer.append('\"').append((CharSequence)e.getKey()).append('\"').append(':').append(' ');
            this.append((JsonElement)e.getValue(), depth);
            empty = false;
        }
        --depth;
        if (!empty) {
            this.writer.append('\n');
            this.indent(depth);
        }
        this.writer.append('}');
    }

    private void indent(int depth) throws IOException {
        while (depth-- > 0) {
            this.writer.append(indent);
        }
    }

    private static boolean isPrimitive(JsonArray array) {
        for (JsonElement e : array) {
            if (e.isJsonPrimitive()) continue;
            return false;
        }
        return true;
    }

    private static boolean isPrimitive(JsonObject obj) {
        for (Map.Entry e : obj.entrySet()) {
            if (((JsonElement)e.getValue()).isJsonPrimitive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

