/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.util.ref;

import com.conquestreforged.common.util.StateMatcher;
import com.conquestreforged.common.util.ref.Ref;
import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class BlockRef
implements Ref {
    private final String reference;
    private Block blockReference = null;
    private IBlockState stateReference = null;

    private BlockRef(String rule) {
        this.reference = rule;
    }

    private BlockRef(IBlockState stateReference) {
        this.reference = stateReference.toString();
        this.blockReference = stateReference.func_177230_c();
        this.stateReference = stateReference;
    }

    public boolean isPresent() {
        return this.getBlock() != Blocks.field_150350_a;
    }

    public Block getBlock() {
        if (this.blockReference == null) {
            this.checkAccess();
            this.blockReference = StateMatcher.blockFromStringUnchecked(this.reference);
        }
        return this.blockReference;
    }

    public IBlockState getState() {
        if (this.stateReference == null) {
            this.checkAccess();
            this.stateReference = StateMatcher.stateFromStringUnchecked(this.reference);
        }
        return this.stateReference;
    }

    public String toString() {
        return this.reference;
    }

    public static BlockRef of(String reference) {
        return new BlockRef(reference);
    }

    public static BlockRef of(Block block) {
        Preconditions.checkNotNull((Object)block);
        return new BlockRef(block.func_176223_P());
    }

    public static BlockRef of(IBlockState state) {
        Preconditions.checkNotNull((Object)state);
        return new BlockRef(state);
    }
}

