/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.util.ref;

import com.conquestreforged.common.data.item.ItemState;
import com.conquestreforged.common.util.ref.Ref;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemRef
implements Ref {
    private final String reference;
    private ItemState itemReference = null;

    private ItemRef(String reference) {
        this.reference = reference;
    }

    private ItemRef(ItemState state) {
        this.reference = state.toString();
        this.itemReference = state;
    }

    public boolean isPresent() {
        return this.getState().isPresent();
    }

    public Item getItem() {
        return this.getState().getItem();
    }

    public ItemStack getStack() {
        return this.getState().getStack();
    }

    private ItemState getState() {
        if (this.itemReference == null) {
            this.checkAccess();
            this.itemReference = ItemState.parse(this.reference);
        }
        return this.itemReference;
    }

    public String toString() {
        return this.reference;
    }

    public static ItemRef of(String reference) {
        return new ItemRef(reference);
    }

    public static ItemRef of(ItemStack stack) {
        return new ItemRef(ItemState.of(stack));
    }
}

