/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world;

import com.conquestreforged.common.world.ModGenLayerDeepOcean;
import com.conquestreforged.common.world.ModGenLayerRiver;
import com.conquestreforged.common.world.ModGenLayerRiverMix;
import com.conquestreforged.common.world.ModGenLayerShore;
import com.conquestreforged.common.world.ModWorldSettings;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Biomes;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerHills;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRareBiome;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ModBiomeProvider
extends BiomeProvider {
    private ChunkGeneratorSettings settings;
    private GenLayer genBiomes;
    private GenLayer biomeIndexLayer;
    private final BiomeCache biomeCache;
    private final List<Biome> biomesToSpawnIn;
    public static List<Biome> allowedBiomes = Lists.newArrayList((Object[])new Biome[]{Biomes.field_76767_f, Biomes.field_76772_c, Biomes.field_76768_g, Biomes.field_76784_u, Biomes.field_76785_t, Biomes.field_76782_w, Biomes.field_76792_x});

    public ModBiomeProvider(long seed, WorldType worldType, String options) {
        if (worldType == WorldType.field_180271_f && !options.isEmpty()) {
            this.settings = ChunkGeneratorSettings.Factory.func_177865_a((String)options).func_177864_b();
        }
        GenLayer[] agenlayer = ModBiomeProvider.initializeAllBiomeGenerators(seed, worldType, this.settings);
        agenlayer = this.getModdedBiomeGenerators(worldType, seed, agenlayer);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
        this.biomeCache = new BiomeCache((BiomeProvider)this);
        this.biomesToSpawnIn = Lists.newArrayList(allowedBiomes);
    }

    public static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType worldtype, ChunkGeneratorSettings modsettings) {
        int i;
        ModWorldSettings modWorldSettings = new ModWorldSettings();
        GenLayerIsland genlayer = new GenLayerIsland(1L);
        genlayer = new GenLayerFuzzyZoom(2000L, (GenLayer)genlayer);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, (GenLayer)genlayer);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, (GenLayer)genlayeraddisland);
        GenLayerAddIsland genlayeraddisland1 = new GenLayerAddIsland(2L, (GenLayer)genlayerzoom);
        genlayeraddisland1 = new GenLayerAddIsland(50L, (GenLayer)genlayeraddisland1);
        genlayeraddisland1 = new GenLayerAddIsland(70L, (GenLayer)genlayeraddisland1);
        GenLayerRemoveTooMuchOcean genlayerremovetoomuchocean = new GenLayerRemoveTooMuchOcean(2L, (GenLayer)genlayeraddisland1);
        GenLayerAddSnow genlayeraddsnow = new GenLayerAddSnow(2L, (GenLayer)genlayerremovetoomuchocean);
        GenLayerAddIsland genlayeraddisland2 = new GenLayerAddIsland(3L, (GenLayer)genlayeraddsnow);
        GenLayerEdge genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeraddisland2, GenLayerEdge.Mode.COOL_WARM);
        genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeredge, GenLayerEdge.Mode.HEAT_ICE);
        genlayeredge = new GenLayerEdge(3L, (GenLayer)genlayeredge, GenLayerEdge.Mode.SPECIAL);
        GenLayerZoom genlayerzoom1 = new GenLayerZoom(2002L, (GenLayer)genlayeredge);
        genlayerzoom1 = new GenLayerZoom(2003L, (GenLayer)genlayerzoom1);
        GenLayerAddIsland genlayeraddisland3 = new GenLayerAddIsland(4L, (GenLayer)genlayerzoom1);
        GenLayerAddMushroomIsland genlayeraddmushroomisland = new GenLayerAddMushroomIsland(5L, (GenLayer)genlayeraddisland3);
        ModGenLayerDeepOcean genlayerdeepocean = new ModGenLayerDeepOcean(4L, (GenLayer)genlayeraddmushroomisland);
        GenLayer genlayer4 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerdeepocean, (int)0);
        int j = i = 4;
        if (modWorldSettings != null) {
            i = modWorldSettings.biomeSize;
            j = modWorldSettings.riverSize;
        }
        if (worldtype == WorldType.field_77135_d) {
            i = 6;
        }
        i = ModBiomeProvider.getModdedBiomeSize(worldtype, i);
        GenLayer lvt_7_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer4, (int)0);
        GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, lvt_7_1_);
        GenLayer genlayerbiomeedge = worldtype.getBiomeLayer(seed, genlayer4, modsettings);
        GenLayer lvt_9_1_ = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        Object genlayerhills = new GenLayerHills(1000L, genlayerbiomeedge, lvt_9_1_);
        GenLayer genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        genlayer5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer5, (int)j);
        ModGenLayerRiver genlayerriver = new ModGenLayerRiver(1L, genlayer5);
        GenLayerSmooth genlayersmooth = new GenLayerSmooth(1000L, (GenLayer)genlayerriver);
        genlayerhills = new GenLayerRareBiome(1001L, (GenLayer)genlayerhills);
        for (int k = 0; k < i; ++k) {
            genlayerhills = new GenLayerZoom((long)(1000 + k), (GenLayer)genlayerhills);
            if (k == 0) {
                genlayerhills = new GenLayerAddIsland(3L, (GenLayer)genlayerhills);
            }
            if (k != 1 && i != 1) continue;
            genlayerhills = new ModGenLayerShore(1000L, (GenLayer)genlayerhills);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, (GenLayer)genlayerhills);
        ModGenLayerRiverMix genlayerrivermix = new ModGenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
        GenLayerVoronoiZoom genlayer3 = new GenLayerVoronoiZoom(10L, (GenLayer)genlayerrivermix);
        genlayerrivermix.func_75905_a(seed);
        genlayer3.func_75905_a(seed);
        return new GenLayer[]{genlayerrivermix, genlayer3, genlayerrivermix};
    }

    public static int getModdedBiomeSize(WorldType worldType, int original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.getNewSize();
    }

    public ModBiomeProvider(World world) {
        this(world.func_72905_C(), world.func_72912_H().func_76067_t(), world.func_72912_H().func_82571_y());
    }

    public List<Biome> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.func_180300_a(pos, null);
    }

    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    public float func_76939_a(float p_76939_1_, int p_76939_2_) {
        return p_76939_1_;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
        try {
            for (int i = 0; i < width * height; ++i) {
                biomes[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
            }
            return biomes;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("w", (Object)width);
            crashreportcategory.func_71507_a("h", (Object)height);
            throw new ReportedException(crashreport);
        }
    }

    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        IntCache.func_76446_a();
        if (listToReuse == null || listToReuse.length < width * length) {
            listToReuse = new Biome[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] abiome = this.biomeCache.func_76839_e(x, z);
            System.arraycopy(abiome, 0, listToReuse, 0, width * length);
            return listToReuse;
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(x, z, width, length);
        for (int i = 0; i < width * length; ++i) {
            listToReuse[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
        }
        return listToReuse;
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int i = x - range >> 2;
        int j = z - range >> 2;
        int k = x + range >> 2;
        int l = z + range >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        BlockPos blockpos = null;
        int k1 = 0;
        for (int l1 = 0; l1 < i1 * j1; ++l1) {
            int i2 = i + l1 % i1 << 2;
            int j2 = j + l1 / i1 << 2;
            Biome biome = Biome.func_150568_d((int)aint[l1]);
            if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
            blockpos = new BlockPos(i2, 0, j2);
            ++k1;
        }
        return blockpos;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int i = x - radius >> 2;
        int j = z - radius >> 2;
        int k = x + radius >> 2;
        int l = z + radius >> 2;
        int i1 = k - i + 1;
        int j1 = l - j + 1;
        int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
        try {
            for (int k1 = 0; k1 < i1 * j1; ++k1) {
                Biome biome = Biome.func_150568_d((int)aint[k1]);
                if (allowed.contains(biome)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.genBiomes.toString());
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", allowed);
            throw new ReportedException(crashreport);
        }
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }

    public GenLayer[] getModdedBiomeGenerators(WorldType worldType, long seed, GenLayer[] original) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.getNewBiomeGens();
    }

    public boolean func_190944_c() {
        return this.settings != null && this.settings.field_177779_F >= 0;
    }

    public Biome func_190943_d() {
        return this.settings != null && this.settings.field_177779_F >= 0 ? Biome.func_185357_a((int)this.settings.field_177779_F) : null;
    }
}

