/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world;

import com.conquestreforged.common.world.ModWorldSettings;
import com.conquestreforged.common.world.ModWorldType;
import com.conquestreforged.init.ModBiomes;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class ModGenLayerBiome
extends GenLayer {
    private List<BiomeManager.BiomeEntry>[] biomes = new ArrayList[BiomeManager.BiomeType.values().length];
    private final ModWorldSettings settings;

    public ModGenLayerBiome(long seed, GenLayer landMassLayer, WorldType worldType, ModWorldSettings settings) {
        super(seed);
        this.field_75909_a = landMassLayer;
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            ImmutableList biomesToAdd = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            int idx = type.ordinal();
            if (this.biomes[idx] == null) {
                this.biomes[idx] = new ArrayList<BiomeManager.BiomeEntry>();
            }
            if (biomesToAdd == null) continue;
            this.biomes[idx].addAll((Collection<BiomeManager.BiomeEntry>)biomesToAdd);
        }
        int desertIdx = BiomeManager.BiomeType.DESERT.ordinal();
        int warmIdx = BiomeManager.BiomeType.WARM.ordinal();
        int coolIdx = BiomeManager.BiomeType.COOL.ordinal();
        int icyIdx = BiomeManager.BiomeType.ICY.ordinal();
        if (worldType instanceof ModWorldType) {
            this.biomes[desertIdx].clear();
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.DESERT, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.RED_DESERT, 10));
            this.biomes[desertIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.MESA_EXTREME, 10));
            this.biomes[warmIdx].clear();
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.BIRCHFOREST, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.BIRCHFOREST_FLOWERPLAIN, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.LORIEN_FOREST, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.MARSH, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.ALDER_SWAMP, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.BAMBOO_FOREST, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.BOG, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.DECIDUOUS_FOREST, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.JAPANESE_FOREST, 5));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.MEDITERRANEAN, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.OLDGROWTH_FOREST, 10));
            this.biomes[warmIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.MOORLAND, 10));
            this.biomes[coolIdx].clear();
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.MOUNTAIN, 10));
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.BOREAL, 10));
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.TUNDRA, 10));
            this.biomes[coolIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.TUNDRA_MARSH, 10));
            this.biomes[icyIdx].clear();
            this.biomes[icyIdx].add(new BiomeManager.BiomeEntry((Biome)ModBiomes.TUNDRA, 10));
            this.settings = settings;
        } else {
            this.settings = settings;
        }
    }

    public int[] func_75904_a(int areaX, int areaY, int areaWidth, int areaHeight) {
        int[] aint = this.field_75909_a.func_75904_a(areaX, areaY, areaWidth, areaHeight);
        int[] aint1 = IntCache.func_76445_a((int)(areaWidth * areaHeight));
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < areaWidth; ++j) {
                this.func_75903_a(j + areaX, i + areaY);
                int k = aint[j + i * areaWidth];
                int l = (k & 0xF00) >> 8;
                k &= 0xFFFFF0FF;
                if (this.settings != null && this.settings.fixedBiome >= 0) {
                    aint1[j + i * areaWidth] = this.settings.fixedBiome;
                    continue;
                }
                if (ModGenLayerBiome.isBiomeOcean(k)) {
                    aint1[j + i * areaWidth] = k;
                    continue;
                }
                if (k == Biome.func_185362_a((Biome)ModBiomes.JAPANESE_FOREST)) {
                    aint1[j + i * areaWidth] = k;
                    continue;
                }
                if (k == 1) {
                    if (l > 0) {
                        if (this.func_75902_a(3) == 0) {
                            aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)ModBiomes.MESA_EXTREME);
                            continue;
                        }
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)ModBiomes.MESA_EXTREME);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.DESERT).biome);
                    continue;
                }
                if (k == 2) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)ModBiomes.JUNGLE);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM).biome);
                    continue;
                }
                if (k == 3) {
                    if (l > 0) {
                        aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)ModBiomes.BOREAL);
                        continue;
                    }
                    aint1[j + i * areaWidth] = Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL).biome);
                    continue;
                }
                aint1[j + i * areaWidth] = k == 4 ? Biome.func_185362_a((Biome)this.getWeightedBiomeEntry((BiomeManager.BiomeType)BiomeManager.BiomeType.ICY).biome) : Biome.func_185362_a((Biome)ModBiomes.DECIDUOUS_FOREST);
            }
        }
        return aint1;
    }

    protected BiomeManager.BiomeEntry getWeightedBiomeEntry(BiomeManager.BiomeType type) {
        List<BiomeManager.BiomeEntry> biomeList = this.biomes[type.ordinal()];
        int totalWeight = WeightedRandom.func_76272_a(biomeList);
        int weight = BiomeManager.isTypeListModded((BiomeManager.BiomeType)type) ? this.func_75902_a(totalWeight) : this.func_75902_a(totalWeight / 10) * 10;
        return (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(biomeList, (int)weight);
    }

    protected static boolean isBiomeOcean(int id) {
        return Biome.func_150568_d((int)id) == ModBiomes.OCEAN_MOD;
    }
}

