/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world;

import com.conquestreforged.init.ModBiomes;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.StructureOceanMonumentPieces;
import net.minecraft.world.gen.structure.StructureStart;

public class ModStructureOceanMonument
extends MapGenStructure {
    private int spacing = 32;
    private int separation = 5;
    public static final List<Biome> WATER_BIOMES = Arrays.asList(new Biome[]{ModBiomes.OCEAN_MOD, ModBiomes.RIVER_MOD});
    public static final List<Biome> SPAWN_BIOMES = Arrays.asList(new Biome[]{ModBiomes.OCEAN_MOD});
    private static final List<Biome.SpawnListEntry> MONUMENT_ENEMIES = Lists.newArrayList();

    public ModStructureOceanMonument() {
    }

    public ModStructureOceanMonument(Map<String, String> p_i45608_1_) {
        this();
        for (Map.Entry<String, String> entry : p_i45608_1_.entrySet()) {
            if (entry.getKey().equals("spacing")) {
                this.spacing = MathHelper.func_82714_a((String)entry.getValue(), (int)this.spacing, (int)1);
                continue;
            }
            if (!entry.getKey().equals("separation")) continue;
            this.separation = MathHelper.func_82714_a((String)entry.getValue(), (int)this.separation, (int)1);
        }
    }

    public String func_143025_a() {
        return "Monument";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.spacing - 1;
        }
        int k = chunkX / this.spacing;
        int l = chunkZ / this.spacing;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387313);
        k *= this.spacing;
        l *= this.spacing;
        if (i == (k += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2) && j == (l += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2)) {
            if (!this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 16, SPAWN_BIOMES)) {
                return false;
            }
            boolean flag = this.field_75039_c.func_72959_q().func_76940_a(i * 16 + 8, j * 16 + 8, 29, WATER_BIOMES);
            if (flag) {
                return true;
            }
        }
        return false;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        return ModStructureOceanMonument.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)10387313, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new StructureOceanMonument.StartMonument(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public List<Biome.SpawnListEntry> getMonsters() {
        return MONUMENT_ENEMIES;
    }

    static {
        MONUMENT_ENEMIES.add(new Biome.SpawnListEntry(EntityGuardian.class, 1, 2, 4));
    }

    public static class StartMonument
    extends StructureStart {
        private final Set<ChunkPos> processed = Sets.newHashSet();
        private boolean wasCreated;

        public StartMonument() {
        }

        public StartMonument(World worldIn, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.create(worldIn, random, chunkX, chunkZ);
        }

        private void create(World worldIn, Random random, int chunkX, int chunkZ) {
            random.setSeed(worldIn.func_72905_C());
            long i = random.nextLong();
            long j = random.nextLong();
            long k = (long)chunkX * i;
            long l = (long)chunkZ * j;
            random.setSeed(k ^ l ^ worldIn.func_72905_C());
            int i1 = chunkX * 16 + 8 - 29;
            int j1 = chunkZ * 16 + 8 - 29;
            EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(random);
            this.field_75075_a.add(new StructureOceanMonumentPieces.MonumentBuilding(random, i1, j1, enumfacing));
            this.func_75072_c();
            this.wasCreated = true;
        }

        public void func_75068_a(World worldIn, Random rand, StructureBoundingBox structurebb) {
            if (!this.wasCreated) {
                this.field_75075_a.clear();
                this.create(worldIn, rand, this.func_143019_e(), this.func_143018_f());
            }
            super.func_75068_a(worldIn, rand, structurebb);
        }

        public boolean func_175788_a(ChunkPos pair) {
            return this.processed.contains(pair) ? false : super.func_175788_a(pair);
        }

        public void func_175787_b(ChunkPos pair) {
            super.func_175787_b(pair);
            this.processed.add(pair);
        }

        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            NBTTagList nbttaglist = new NBTTagList();
            for (ChunkPos chunkpos : this.processed) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74768_a("X", chunkpos.field_77276_a);
                nbttagcompound.func_74768_a("Z", chunkpos.field_77275_b);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            tagCompound.func_74782_a("Processed", (NBTBase)nbttaglist);
        }

        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            if (tagCompound.func_150297_b("Processed", 9)) {
                NBTTagList nbttaglist = tagCompound.func_150295_c("Processed", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                    this.processed.add(new ChunkPos(nbttagcompound.func_74762_e("X"), nbttagcompound.func_74762_e("Z")));
                }
            }
        }
    }
}

