/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world;

import com.conquestreforged.common.blockmeta.BlockSimpleMeta;
import com.conquestreforged.common.world.StonePredicateGravel;
import com.conquestreforged.common.world.StonePredicateHardness2;
import com.conquestreforged.common.world.StonePredicateHardness3;
import com.conquestreforged.common.world.StonePredicateHardness4;
import com.conquestreforged.common.world.StonePredicateHardness5;
import com.conquestreforged.common.world.StonePredicateNetherrack;
import com.conquestreforged.common.world.StonePredicateSandstone;
import com.conquestreforged.common.world.StonePredicateSchist;
import com.conquestreforged.init.ModBlocks;
import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    private WorldGenerator nether_quartz = new WorldGenMinable(Blocks.field_150449_bY.func_176223_P(), 33, (Predicate)new StonePredicateNetherrack());
    private WorldGenerator coal = new WorldGenMinable(Blocks.field_150365_q.func_176223_P(), 33, (Predicate)new StonePredicateHardness4());
    private WorldGenerator iron = new WorldGenMinable(Blocks.field_150366_p.func_176223_P(), 29, (Predicate)new StonePredicateHardness4());
    private WorldGenerator lapis = new WorldGenMinable(Blocks.field_150369_x.func_176223_P(), 16, (Predicate)new StonePredicateHardness3());
    private WorldGenerator gold = new WorldGenMinable(Blocks.field_150352_o.func_176223_P(), 13, (Predicate)new StonePredicateHardness3());
    private WorldGenerator diamond = new WorldGenMinable(Blocks.field_150482_ag.func_176223_P(), 7, (Predicate)new StonePredicateHardness5());
    private WorldGenerator redstone = new WorldGenMinable(Blocks.field_150450_ax.func_176223_P(), 23, (Predicate)new StonePredicateHardness5());
    private WorldGenerator emerald = new WorldGenMinable(Blocks.field_150412_bA.func_176223_P(), 13, (Predicate)new StonePredicateHardness3());
    private WorldGenerator copper = new WorldGenMinable(ModBlocks.stone_full_hard2.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.JULIET)), 29, (Predicate)new StonePredicateHardness2());
    private WorldGenerator tin = new WorldGenMinable(ModBlocks.stone_full_hard2.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.KILO)), 29, (Predicate)new StonePredicateHardness2());
    private WorldGenerator sandstone_debris = new WorldGenMinable(ModBlocks.gravel_full_1.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.GOLF)), 46, (Predicate)new StonePredicateSandstone());
    private WorldGenerator schist_debris = new WorldGenMinable(ModBlocks.gravel_full_1.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.HOTEL)), 46, (Predicate)new StonePredicateSchist());
    private WorldGenerator gravel = new WorldGenMinable(Blocks.field_150351_n.func_176223_P(), 46, (Predicate)new StonePredicateGravel());
    private WorldGenerator small_stones = new WorldGenMinable(ModBlocks.gravel_full_1.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ALPHA)), 46, (Predicate)new StonePredicateGravel());

    private void runGenerator(WorldGenerator generator, World world, Random rand, int chunk_X, int chunk_Z, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenerator");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunk_X * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunk_Z * 16 + rand.nextInt(16);
            generator.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.runGenerator(this.coal, world, random, chunkX, chunkZ, 4, 1, 200);
                this.runGenerator(this.iron, world, random, chunkX, chunkZ, 4, 1, 200);
                this.runGenerator(this.lapis, world, random, chunkX, chunkZ, 3, 1, 200);
                this.runGenerator(this.gold, world, random, chunkX, chunkZ, 3, 1, 200);
                this.runGenerator(this.diamond, world, random, chunkX, chunkZ, 2, 1, 200);
                this.runGenerator(this.redstone, world, random, chunkX, chunkZ, 3, 1, 200);
                this.runGenerator(this.emerald, world, random, chunkX, chunkZ, 3, 1, 200);
                this.runGenerator(this.copper, world, random, chunkX, chunkZ, 4, 1, 200);
                this.runGenerator(this.tin, world, random, chunkX, chunkZ, 4, 1, 200);
                this.runGenerator(this.sandstone_debris, world, random, chunkX, chunkZ, 6, 1, 200);
                this.runGenerator(this.schist_debris, world, random, chunkX, chunkZ, 6, 1, 200);
                this.runGenerator(this.gravel, world, random, chunkX, chunkZ, 7, 1, 200);
                this.runGenerator(this.small_stones, world, random, chunkX, chunkZ, 6, 1, 200);
                break;
            }
            case 1: {
                break;
            }
            case -1: {
                this.runGenerator(this.nether_quartz, world, random, chunkX, chunkZ, 10, 1, 200);
            }
        }
    }
}

