/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world.biome;

import com.conquestreforged.common.blockmeta.BlockBiomeNoCollisionRandomMeta;
import com.conquestreforged.common.blockmeta.BlockNoCollisionRandomMeta;
import com.conquestreforged.common.blockmeta.BlockSimpleMeta;
import com.conquestreforged.common.blockmeta.BlockStonesMeta;
import com.conquestreforged.common.util.WeightedList;
import com.conquestreforged.common.world.generation.WorldGenGrassCover;
import com.conquestreforged.common.world.generation.WorldTreeFSC;
import com.conquestreforged.common.world.generation.WorldTreeFSP;
import com.conquestreforged.common.world.generation.WorldTreeLSC;
import com.conquestreforged.common.world.generation.WorldTreeLSP;
import com.conquestreforged.common.world.generation.WorldTreeMSC;
import com.conquestreforged.common.world.generation.WorldTreeTFI;
import com.conquestreforged.common.world.generation.WorldTreeTSC;
import com.conquestreforged.common.world.generation.WorldTreeTSP;
import com.conquestreforged.common.world.generation.WorldTreeZSC;
import com.conquestreforged.common.world.generation.WorldTreeZSP;
import com.conquestreforged.common.world.generation.marsh.WorldGenGrassBlockCover;
import com.conquestreforged.init.ModBlocks;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeMesa
extends Biome {
    private final WeightedList<WorldGenAbstractTree> trees = WeightedList.create().add(new WorldTreeTFI(false)).add((WorldTreeTFI)((Object)new WorldTreeFSP(false))).add((WorldTreeTFI)((Object)new WorldTreeLSP(false))).add((WorldTreeTFI)((Object)new WorldTreeZSP(false))).add((WorldTreeTFI)((Object)new WorldTreeTSP(false))).add((WorldTreeTFI)((Object)new WorldTreeZSC(false))).add((WorldTreeTFI)((Object)new WorldTreeTSC(false))).add((WorldTreeTFI)((Object)new WorldTreeFSC(false))).add((WorldTreeTFI)((Object)new WorldTreeMSC(false))).add((WorldTreeTFI)((Object)new WorldTreeLSC(false)));
    private final WeightedList<WorldGenGrassCover> grasses = WeightedList.create().add(new WorldGenGrassCover(ModBlocks.stone_rocks_1.getBlock().func_176223_P().func_177226_a(BlockStonesMeta.VARIANT, (Comparable)((Object)BlockStonesMeta.EnumType.FOX))), 0.1).add(new WorldGenGrassCover(ModBlocks.plants_nocollision_2.getBlock().func_176223_P().func_177226_a(BlockNoCollisionRandomMeta.VARIANT, (Comparable)((Object)BlockNoCollisionRandomMeta.EnumType.LIMA))), 3.0).add(new WorldGenGrassBlockCover(ModBlocks.plants_nocollision_10.getBlock().func_176223_P().func_177226_a(BlockNoCollisionRandomMeta.VARIANT, (Comparable)((Object)BlockNoCollisionRandomMeta.EnumType.LIMA))), 8.0).add(new WorldGenGrassBlockCover(ModBlocks.plants_nocollisionbiome_1.getBlock().func_176223_P().func_177226_a(BlockBiomeNoCollisionRandomMeta.VARIANT, (Comparable)((Object)BlockBiomeNoCollisionRandomMeta.EnumType.BRAVO))), 6.0).add(new WorldGenGrassCover(ModBlocks.plants_nocollision_3.getBlock().func_176223_P().func_177226_a(BlockNoCollisionRandomMeta.VARIANT, (Comparable)((Object)BlockNoCollisionRandomMeta.EnumType.KILO))), 3.0).add(new WorldGenGrassCover(ModBlocks.plants_nocollision_5.getBlock().func_176223_P().func_177226_a(BlockNoCollisionRandomMeta.VARIANT, (Comparable)((Object)BlockNoCollisionRandomMeta.EnumType.BRAVO))), 0.3);
    protected static final IBlockState GRASS = Blocks.field_150349_c.func_176223_P();
    protected static final IBlockState STAINED_HARDENED_CLAY = Blocks.field_150406_ce.func_176223_P();
    protected static final IBlockState RED_SAND = Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND);
    private IBlockState[] clayBands;
    private long worldSeed;
    private NoiseGeneratorPerlin pillarNoise;
    private NoiseGeneratorPerlin pillarRoofNoise;
    private NoiseGeneratorPerlin clayBandsOffsetNoise;
    private final boolean brycePillars;
    private final boolean hasForest;

    public BiomeMesa(boolean bryce, boolean forest, Biome.BiomeProperties properties) {
        super(properties);
        this.brycePillars = bryce;
        this.hasForest = forest;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityLlama.class, 4, 2, 3));
        this.field_76752_A = RED_SAND;
        this.field_76753_B = STAINED_HARDENED_CLAY;
        this.field_76760_I.field_76832_z = -999;
        this.field_76760_I.field_76799_E = 3;
        this.field_76760_I.field_76802_A = 0;
        this.field_76760_I.field_76803_B = 300;
        if (forest) {
            this.field_76760_I.field_76832_z = 8;
        }
    }

    public BiomeDecorator func_76729_a() {
        return new Decorator();
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return this.trees.next(rand);
    }

    public WorldGenerator func_76730_b(Random rand) {
        return this.grasses.next(rand);
    }

    public void func_180622_a(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal) {
        IBlockState fillerBlock6;
        IBlockState topBlock = this.field_76752_A;
        if (this.clayBands == null || this.worldSeed != worldIn.func_72905_C()) {
            this.generateBands(worldIn.func_72905_C());
        }
        if (this.pillarNoise == null || this.pillarRoofNoise == null || this.worldSeed != worldIn.func_72905_C()) {
            Random random = new Random(this.worldSeed);
            this.pillarNoise = new NoiseGeneratorPerlin(random, 4);
            this.pillarRoofNoise = new NoiseGeneratorPerlin(random, 1);
        }
        this.worldSeed = worldIn.func_72905_C();
        double d4 = 0.0;
        if (this.brycePillars) {
            int i = (x & 0xFFFFFFF0) + (z & 0xF);
            int j = (z & 0xFFFFFFF0) + (x & 0xF);
            double d0 = Math.min(Math.abs(noiseVal), this.pillarNoise.func_151601_a((double)i * 0.25, (double)j * 0.25));
            if (d0 > 0.0) {
                double d1 = 0.001953125;
                d4 = d0 * d0 * 2.5;
                double d2 = Math.abs(this.pillarRoofNoise.func_151601_a((double)i * 0.001953125, (double)j * 0.001953125));
                double d3 = Math.ceil(d2 * 50.0) + 14.0;
                if (d4 > d3) {
                    d4 = d3;
                }
                d4 += 64.0;
            }
        }
        int k1 = x & 0xF;
        int l1 = z & 0xF;
        int i2 = worldIn.func_181545_F();
        IBlockState iblockstate = ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO));
        IBlockState iblockstate3 = this.field_76753_B;
        int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        boolean flag = Math.cos(noiseVal / 3.0 * Math.PI) > 0.0;
        int l = -1;
        boolean flag1 = false;
        int i1 = 0;
        for (int j1 = 255; j1 >= 0; --j1) {
            double topBlockRand = Math.random();
            if (topBlockRand > 0.7) {
                topBlock = Blocks.field_150349_c.func_176223_P();
            } else if (topBlockRand > 0.4) {
                topBlock = ModBlocks.ground_full_1.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.FOX));
            } else if (topBlockRand > 0.2) {
                topBlock = ModBlocks.stone_full_19.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.INDIA));
            } else if (topBlockRand > 0.05) {
                topBlock = ModBlocks.gravel_full_1.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.GOLF));
            } else if (topBlockRand > 0.0) {
                topBlock = ModBlocks.ground_full_1.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.JULIET));
            }
            if (chunkPrimerIn.func_177856_a(l1, j1, k1).func_185904_a() == Material.field_151579_a && j1 < (int)d4) {
                chunkPrimerIn.func_177855_a(l1, j1, k1, field_185365_a);
            }
            if (j1 <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(l1, j1, k1, field_185367_c);
                continue;
            }
            if (i1 >= 15 && !this.brycePillars) continue;
            IBlockState iblockstate1 = chunkPrimerIn.func_177856_a(l1, j1, k1);
            if (iblockstate1.func_185904_a() == Material.field_151579_a) {
                l = -1;
                continue;
            }
            if (iblockstate1.func_177230_c() != Blocks.field_150348_b) continue;
            if (l == -1) {
                flag1 = false;
                if (k <= 0) {
                    iblockstate = field_185366_b;
                    iblockstate3 = field_185365_a;
                } else if (j1 >= i2 - 4 && j1 <= i2 + 1) {
                    iblockstate = ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO));
                    iblockstate3 = this.field_76753_B;
                }
                l = k + Math.max(0, j1 - i2);
                if (j1 >= i2 - 1) {
                    if (j1 > i2 + 3 + k) {
                        IBlockState iblockstate2 = j1 >= 64 && j1 <= 127 ? (flag ? ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.GOLF)) : this.getBand(x, j1, z)) : ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.HOTEL));
                        chunkPrimerIn.func_177855_a(l1, j1, k1, iblockstate2);
                    } else {
                        chunkPrimerIn.func_177855_a(l1, j1, k1, topBlock);
                        flag1 = true;
                    }
                } else {
                    chunkPrimerIn.func_177855_a(l1, j1, k1, iblockstate3);
                    if (iblockstate3.func_177230_c() == ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO))) {
                        chunkPrimerIn.func_177855_a(l1, j1, k1, ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.GOLF)));
                    }
                }
            } else if (l > 0) {
                --l;
                if (flag1) {
                    chunkPrimerIn.func_177855_a(l1, j1, k1, STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED));
                } else {
                    chunkPrimerIn.func_177855_a(l1, j1, k1, this.getBand(x, j1, z));
                }
            }
            ++i1;
        }
        IBlockState fillerBlock2 = ModBlocks.stone_full_14.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.MIKE));
        IBlockState fillerBlock3 = ModBlocks.stone_full_hard2.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.FOX));
        IBlockState transitionBlock = fillerBlock2;
        IBlockState transitionBlock1 = fillerBlock3;
        IBlockState fillerBlock4 = ModBlocks.stone_full_hard3.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.BRAVO));
        IBlockState transitionBlock2 = fillerBlock3;
        IBlockState transitionBlock3 = fillerBlock4;
        IBlockState fillerBlock5 = ModBlocks.stone_full_hard4.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.DELTA));
        IBlockState transitionBlock4 = fillerBlock4;
        IBlockState transitionBlock5 = fillerBlock5;
        IBlockState transitionBlock6 = fillerBlock6 = ModBlocks.stone_full_hard5.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO));
        boolean hitFloorYet = false;
        int topBlocksToFill = 0;
        int dirtBlocksToFill = 0;
        int fill2BlocksToFill = 5;
        int fill3BlocksToFill = 2;
        int transitionBlocksToFill = 1;
        int fill3BlocksToFill_1 = 6;
        int transitionBlocksToFill_1 = 1;
        int fill3BlocksToFill_2 = 2;
        int fill4BlocksToFill = 2;
        int transitionBlocksToFill_2 = 1;
        int fill4BlocksToFill_1 = 6;
        int transitionBlocksToFill_3 = 1;
        int fill4BlocksToFill_2 = 2;
        int fill5BlocksToFill = 2;
        int transitionBlocksToFill_4 = 1;
        int fill5BlocksToFill_1 = 6;
        int transitionBlocksToFill_5 = 1;
        int fill5BlocksToFill_2 = 2;
        int fill6BlocksToFill = 2;
        int transitionBlocksToFill_6 = 1;
        int fill6BlocksToFill_1 = 120;
        int dirtDepth = 1;
        int localX = x & 0xF;
        int localZ = z & 0xF;
        for (int y = 255; y >= 0; --y) {
            IBlockState state = chunkPrimerIn.func_177856_a(localZ, y, localX);
            double topBlockRand = Math.random();
            if (noiseVal > 1.75) {
                transitionBlock = fillerBlock2;
            } else if (noiseVal > -0.95) {
                transitionBlock = fillerBlock3;
            }
            if (noiseVal > -0.65) {
                transitionBlock1 = fillerBlock3;
            } else if (noiseVal > 2.05) {
                transitionBlock1 = fillerBlock4;
            }
            if (noiseVal > 1.75) {
                transitionBlock2 = fillerBlock3;
            } else if (noiseVal > -0.95) {
                transitionBlock2 = fillerBlock4;
            }
            if (noiseVal > -0.65) {
                transitionBlock3 = fillerBlock4;
            } else if (noiseVal > 2.05) {
                transitionBlock3 = fillerBlock5;
            }
            if (noiseVal > 1.75) {
                transitionBlock4 = fillerBlock4;
            } else if (noiseVal > -0.95) {
                transitionBlock4 = fillerBlock5;
            }
            if (noiseVal > -0.65) {
                transitionBlock5 = fillerBlock5;
            } else if (noiseVal > 2.05) {
                transitionBlock5 = fillerBlock6;
            }
            if (noiseVal > 1.75) {
                transitionBlock6 = fillerBlock5;
            } else if (noiseVal > -0.95) {
                transitionBlock6 = fillerBlock6;
            }
            if (y <= rand.nextInt(5)) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (state.func_185904_a() == Material.field_151579_a) {
                topBlocksToFill = topBlock == null ? 0 : 1;
                dirtBlocksToFill = dirtDepth;
                continue;
            }
            if (state.func_177230_c() != Blocks.field_150348_b && (state.func_177230_c() != Blocks.field_150350_a || y > 62) && (state.func_177230_c() != Blocks.field_150355_j || y > 62)) continue;
            hitFloorYet = true;
            if (y > 50 && (chunkPrimerIn.func_177856_a(localZ, y, localX).func_185904_a() == Material.field_151579_a || chunkPrimerIn.func_177856_a(localZ, y, localX).func_185904_a() == Material.field_151579_a || chunkPrimerIn.func_177856_a(localZ, y, localX).func_185904_a() == Material.field_151579_a || chunkPrimerIn.func_177856_a(localZ, y, localX).func_185904_a() == Material.field_151579_a)) {
                topBlocksToFill = 0;
                dirtBlocksToFill = 0;
            }
            if (topBlocksToFill > 0) {
                if (y >= 62) {
                    chunkPrimerIn.func_177855_a(localZ, y, localX, topBlock);
                } else if (y >= 56 - dirtDepth) {
                    chunkPrimerIn.func_177855_a(localZ, y, localX, this.field_76753_B);
                } else if (y >= 40) {
                    chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock2);
                } else if (y >= 5) {
                    chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock3);
                } else {
                    chunkPrimerIn.func_177855_a(localZ, y, localX, Blocks.field_150351_n.func_176223_P());
                    dirtBlocksToFill = 0;
                }
                --topBlocksToFill;
                continue;
            }
            if (dirtBlocksToFill > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, this.field_76753_B);
                --dirtBlocksToFill;
                continue;
            }
            if (fill2BlocksToFill > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock2);
                --fill2BlocksToFill;
                continue;
            }
            if (fill3BlocksToFill > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock3);
                --fill3BlocksToFill;
                continue;
            }
            if (transitionBlocksToFill > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, transitionBlock);
                --transitionBlocksToFill;
                continue;
            }
            if (fill3BlocksToFill_1 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock3);
                --fill3BlocksToFill_1;
                continue;
            }
            if (transitionBlocksToFill_1 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, transitionBlock1);
                --transitionBlocksToFill_1;
                continue;
            }
            if (fill3BlocksToFill_2 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock3);
                --fill3BlocksToFill_2;
                continue;
            }
            if (fill4BlocksToFill > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock4);
                --fill4BlocksToFill;
                continue;
            }
            if (transitionBlocksToFill_2 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, transitionBlock2);
                --transitionBlocksToFill_2;
                continue;
            }
            if (fill4BlocksToFill_1 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock4);
                --fill4BlocksToFill_1;
                continue;
            }
            if (transitionBlocksToFill_3 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, transitionBlock3);
                --transitionBlocksToFill_3;
                continue;
            }
            if (fill4BlocksToFill_2 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock4);
                --fill4BlocksToFill_2;
                continue;
            }
            if (fill5BlocksToFill > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock5);
                --fill5BlocksToFill;
                continue;
            }
            if (transitionBlocksToFill_4 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, transitionBlock4);
                --transitionBlocksToFill_4;
                continue;
            }
            if (fill5BlocksToFill_1 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock5);
                --fill5BlocksToFill_1;
                continue;
            }
            if (transitionBlocksToFill_5 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, transitionBlock5);
                --transitionBlocksToFill_5;
                continue;
            }
            if (fill5BlocksToFill_2 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock5);
                --fill5BlocksToFill_2;
                continue;
            }
            if (fill6BlocksToFill > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock6);
                --fill6BlocksToFill;
                continue;
            }
            if (transitionBlocksToFill_6 > 0) {
                chunkPrimerIn.func_177855_a(localZ, y, localX, transitionBlock6);
                --transitionBlocksToFill_6;
                continue;
            }
            if (fill6BlocksToFill_1 <= 0) continue;
            chunkPrimerIn.func_177855_a(localZ, y, localX, fillerBlock6);
            --fill6BlocksToFill_1;
        }
    }

    public void generateBands(long p_150619_1_) {
        this.clayBands = new IBlockState[64];
        Arrays.fill(this.clayBands, ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO)));
        Random random = new Random(p_150619_1_);
        this.clayBandsOffsetNoise = new NoiseGeneratorPerlin(random, 1);
        for (int l1 = 0; l1 < 64; ++l1) {
            if ((l1 += random.nextInt(5) + 1) >= 64) continue;
            this.clayBands[l1] = ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO));
        }
        int i2 = random.nextInt(4) + 2;
        for (int i = 0; i < i2; ++i) {
            int j = random.nextInt(3) + 1;
            int k = random.nextInt(64);
            for (int l = 0; k + l < 64 && l < j; ++l) {
                this.clayBands[k + l] = ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.GOLF));
            }
        }
        int j2 = random.nextInt(4) + 2;
        for (int k2 = 0; k2 < j2; ++k2) {
            int i3 = random.nextInt(3) + 2;
            int l3 = random.nextInt(64);
            for (int i1 = 0; l3 + i1 < 64 && i1 < i3; ++i1) {
                this.clayBands[l3 + i1] = ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.HOTEL));
            }
        }
        int l2 = random.nextInt(4) + 2;
        for (int j3 = 0; j3 < l2; ++j3) {
            int i4 = random.nextInt(3) + 1;
            int k4 = random.nextInt(64);
            for (int j1 = 0; k4 + j1 < 64 && j1 < i4; ++j1) {
                this.clayBands[k4 + j1] = STAINED_HARDENED_CLAY.func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
            }
        }
        int k3 = random.nextInt(3) + 3;
        int j4 = 0;
        for (int l4 = 0; l4 < k3; ++l4) {
            boolean i5 = true;
            j4 += random.nextInt(16) + 4;
            for (int k1 = 0; j4 + k1 < 64 && k1 < 1; ++k1) {
                this.clayBands[j4 + k1] = ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.HOTEL));
                if (j4 + k1 > 1 && random.nextBoolean()) {
                    this.clayBands[j4 + k1 - 1] = ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO));
                }
                if (j4 + k1 >= 63 || !random.nextBoolean()) continue;
                this.clayBands[j4 + k1 + 1] = ModBlocks.stone_full_18.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO));
            }
        }
    }

    public IBlockState getBand(int p_180629_1_, int p_180629_2_, int p_180629_3_) {
        int i = (int)Math.round(this.clayBandsOffsetNoise.func_151601_a((double)p_180629_1_ / 512.0, (double)p_180629_1_ / 512.0) * 2.0);
        return this.clayBands[(p_180629_2_ + i + 64) % 64];
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return 10387789;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return 9470285;
    }

    class Decorator
    extends BiomeDecorator {
        private Decorator() {
        }

        protected void func_76797_b(World worldIn, Random random) {
            super.func_76797_b(worldIn, random);
            if (TerrainGen.generateOre((World)worldIn, (Random)random, (WorldGenerator)this.field_76819_m, (BlockPos)this.field_180294_c, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.GOLD)) {
                this.func_76795_a(worldIn, random, 20, this.field_76819_m, 32, 80);
            }
        }
    }
}

