/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world.biome;

import com.conquestreforged.common.blockmeta.BlockLeavesNewMeta;
import com.conquestreforged.common.blockmeta.BlockNoCollisionRandomMeta;
import com.conquestreforged.common.blockmeta.BlockSimpleMeta;
import com.conquestreforged.common.util.WeightedList;
import com.conquestreforged.common.world.generation.WorldGenBlockBall;
import com.conquestreforged.common.world.generation.WorldGenGrassCover;
import com.conquestreforged.common.world.generation.WorldTreeSHC;
import com.conquestreforged.common.world.generation.WorldTreeSOK;
import com.conquestreforged.common.world.generation.WorldTreeTHC;
import com.conquestreforged.common.world.generation.WorldTreeTOK;
import com.conquestreforged.common.world.generation.WorldTreeTSP;
import com.conquestreforged.common.world.generation.marsh.WorldGenGrassTightBlockCover;
import com.conquestreforged.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeMoorland
extends Biome {
    private final Type type;
    protected static final WorldGenBlockBall ACACIA_BUSH_GENERATOR = new WorldGenBlockBall(ModBlocks.leaves_fullbiome_3.getBlock().func_176223_P().func_177226_a(BlockLeavesNewMeta.VARIANT, (Comparable)((Object)BlockLeavesNewMeta.EnumType.ALPHA)).func_177226_a((IProperty)BlockLeavesNewMeta.CHECK_DECAY, (Comparable)Boolean.FALSE), 0);
    protected static final WorldGenBlockBall BIRCH_BUSH_GENERATOR = new WorldGenBlockBall(ModBlocks.leaves_fullbiome_2.getBlock().func_176223_P().func_177226_a(BlockLeavesNewMeta.VARIANT, (Comparable)((Object)BlockLeavesNewMeta.EnumType.CHARLIE)).func_177226_a((IProperty)BlockLeavesNewMeta.CHECK_DECAY, (Comparable)Boolean.FALSE), 0);
    protected static final WorldGenBlockBall BRIGHTAPPLELEAVES_BUSH_GENERATOR = new WorldGenBlockBall(ModBlocks.leaves_fullbiome_1.getBlock().func_176223_P().func_177226_a(BlockLeavesNewMeta.VARIANT, (Comparable)((Object)BlockLeavesNewMeta.EnumType.ALPHA)).func_177226_a((IProperty)BlockLeavesNewMeta.CHECK_DECAY, (Comparable)Boolean.FALSE), 0);
    private final WeightedList<WorldGenAbstractTree> trees = WeightedList.create().add(new WorldTreeTOK(false)).add((WorldTreeTOK)((Object)new WorldTreeSOK(false))).add((WorldTreeTOK)((Object)new WorldTreeTSP(false))).add((WorldTreeTOK)((Object)new WorldTreeTHC(false))).add((WorldTreeTOK)((Object)new WorldTreeSHC(false)));
    private final WeightedList<WorldGenGrassCover> grasses = WeightedList.create().add(new WorldGenGrassCover(ModBlocks.plants_nocollision_3.getBlock().func_176223_P().func_177226_a(BlockNoCollisionRandomMeta.VARIANT, (Comparable)((Object)BlockNoCollisionRandomMeta.EnumType.CHARLIE))), 3.0).add(new WorldGenGrassCover(ModBlocks.plants_nocollision_10.getBlock().func_176223_P().func_177226_a(BlockNoCollisionRandomMeta.VARIANT, (Comparable)((Object)BlockNoCollisionRandomMeta.EnumType.ALPHA))), 5.0).add(new WorldGenGrassTightBlockCover(ModBlocks.plants_nocollision_2.getBlock().func_176223_P().func_177226_a(BlockNoCollisionRandomMeta.VARIANT, (Comparable)((Object)BlockNoCollisionRandomMeta.EnumType.NOVEMBER))), 10.0).add(new WorldGenGrassCover(ModBlocks.bush_bilberry.getBlock().func_176223_P()), 2.0).add(new WorldGenGrassCover(Blocks.field_150328_O.func_176223_P().func_177226_a(Blocks.field_150328_O.func_176494_l(), (Comparable)BlockFlower.EnumFlowerType.HOUSTONIA)), 0.01).add(new WorldGenGrassCover(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN)), 1.0).add(new WorldGenGrassCover(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS)), 1.0);

    public BiomeMoorland(Type typeIn, Biome.BiomeProperties properties) {
        super(properties);
        this.type = typeIn;
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityHorse.class, 8, 4, 4));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityCow.class, 4, 2, 3));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySheep.class, 4, 2, 3));
        this.field_76760_I.field_76832_z = 0;
        this.field_76760_I.field_76802_A = 0;
        this.field_76760_I.field_76798_D = 0;
        this.field_76760_I.field_76803_B = 1000;
    }

    public int func_180627_b(BlockPos pos) {
        return 12899957;
    }

    public int func_180625_c(BlockPos pos) {
        return 12899957;
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return this.trees.next(rand);
    }

    public WorldGenerator func_76730_b(Random rand) {
        return this.grasses.next(rand);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        WorldGenBlockBall BUSH = ACACIA_BUSH_GENERATOR;
        double bushRand = Math.random();
        if (bushRand > 0.66) {
            BUSH = ACACIA_BUSH_GENERATOR;
        } else if (bushRand > 0.33) {
            BUSH = BIRCH_BUSH_GENERATOR;
        } else if (bushRand > 0.0) {
            BUSH = BRIGHTAPPLELEAVES_BUSH_GENERATOR;
        }
        if (TerrainGen.decorate((World)worldIn, (Random)rand, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.ROCK)) {
            int i = rand.nextInt(3);
            for (int j = 0; j < i; ++j) {
                int k = rand.nextInt(16) + 8;
                int l = rand.nextInt(16) + 8;
                BlockPos blockpos = worldIn.func_175645_m(pos.func_177982_a(k, 0, l));
                BUSH.func_180709_b(worldIn, rand, blockpos);
            }
        }
        super.func_180624_a(worldIn, rand, pos);
    }

    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double stoneNoiseVal) {
        IBlockState fillerBlock6;
        IBlockState topBlock = this.field_76752_A;
        IBlockState fillerBlock = this.field_76753_B;
        IBlockState fillerBlock2 = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
        IBlockState fillerBlock3 = ModBlocks.stone_full_hard2.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.FOX));
        IBlockState transitionBlock = fillerBlock2;
        IBlockState transitionBlock1 = fillerBlock3;
        IBlockState fillerBlock4 = ModBlocks.stone_full_hard3.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.BRAVO));
        IBlockState transitionBlock2 = fillerBlock3;
        IBlockState transitionBlock3 = fillerBlock4;
        IBlockState fillerBlock5 = ModBlocks.stone_full_hard4.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO));
        IBlockState transitionBlock4 = fillerBlock4;
        IBlockState transitionBlock5 = fillerBlock5;
        IBlockState transitionBlock6 = fillerBlock6 = ModBlocks.stone_full_hard5.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.CHARLIE));
        boolean hitFloorYet = false;
        int topBlocksToFill = 0;
        int dirtBlocksToFill = 0;
        int fill2BlocksToFill = 5;
        int fill3BlocksToFill = 2;
        int transitionBlocksToFill = 1;
        int fill3BlocksToFill_1 = 6;
        int transitionBlocksToFill_1 = 1;
        int fill3BlocksToFill_2 = 2;
        int fill4BlocksToFill = 2;
        int transitionBlocksToFill_2 = 1;
        int fill4BlocksToFill_1 = 6;
        int transitionBlocksToFill_3 = 1;
        int fill4BlocksToFill_2 = 2;
        int fill5BlocksToFill = 2;
        int transitionBlocksToFill_4 = 1;
        int fill5BlocksToFill_1 = 6;
        int transitionBlocksToFill_5 = 1;
        int fill5BlocksToFill_2 = 2;
        int fill6BlocksToFill = 2;
        int transitionBlocksToFill_6 = 1;
        int fill6BlocksToFill_1 = 120;
        int dirtDepth = 1;
        int localX = x & 0xF;
        int localZ = z & 0xF;
        for (int y = 255; y >= 0; --y) {
            IBlockState state = primer.func_177856_a(localZ, y, localX);
            double topBlockRand = Math.random();
            if (topBlockRand > 0.5) {
                fillerBlock5 = ModBlocks.stone_full_hard4.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.ECHO));
            } else if (topBlockRand > 0.0) {
                fillerBlock5 = ModBlocks.stone_full_hard4.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.HOTEL));
            }
            if (topBlockRand > 0.6) {
                fillerBlock6 = ModBlocks.stone_full_hard5.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.BRAVO));
            } else if (topBlockRand > 0.0) {
                fillerBlock6 = ModBlocks.stone_full_hard5.getBlock().func_176223_P().func_177226_a(BlockSimpleMeta.VARIANT, (Comparable)((Object)BlockSimpleMeta.EnumType.CHARLIE));
            }
            if (stoneNoiseVal > 1.75) {
                transitionBlock = fillerBlock2;
            } else if (stoneNoiseVal > -0.95) {
                transitionBlock = fillerBlock3;
            }
            if (stoneNoiseVal > -0.65) {
                transitionBlock1 = fillerBlock3;
            } else if (stoneNoiseVal > 2.05) {
                transitionBlock1 = fillerBlock4;
            }
            if (stoneNoiseVal > 1.75) {
                transitionBlock2 = fillerBlock3;
            } else if (stoneNoiseVal > -0.95) {
                transitionBlock2 = fillerBlock4;
            }
            if (stoneNoiseVal > -0.65) {
                transitionBlock3 = fillerBlock4;
            } else if (stoneNoiseVal > 2.05) {
                transitionBlock3 = fillerBlock5;
            }
            if (stoneNoiseVal > 1.75) {
                transitionBlock4 = fillerBlock4;
            } else if (stoneNoiseVal > -0.95) {
                transitionBlock4 = fillerBlock5;
            }
            if (stoneNoiseVal > -0.65) {
                transitionBlock5 = fillerBlock5;
            } else if (stoneNoiseVal > 2.05) {
                transitionBlock5 = fillerBlock6;
            }
            if (stoneNoiseVal > 1.75) {
                transitionBlock6 = fillerBlock5;
            } else if (stoneNoiseVal > -0.95) {
                transitionBlock6 = fillerBlock6;
            }
            if (y <= rand.nextInt(5)) {
                primer.func_177855_a(localZ, y, localX, Blocks.field_150357_h.func_176223_P());
                continue;
            }
            if (state.func_185904_a() == Material.field_151579_a) {
                topBlocksToFill = topBlock == null ? 0 : 1;
                dirtBlocksToFill = dirtDepth;
                continue;
            }
            if (state.func_177230_c() != Blocks.field_150348_b) continue;
            hitFloorYet = true;
            if (y > 50 && (primer.func_177856_a(localZ, y, localX).func_185904_a() == Material.field_151579_a || primer.func_177856_a(localZ, y, localX).func_185904_a() == Material.field_151579_a || primer.func_177856_a(localZ, y, localX).func_185904_a() == Material.field_151579_a || primer.func_177856_a(localZ, y, localX).func_185904_a() == Material.field_151579_a)) {
                topBlocksToFill = 0;
                dirtBlocksToFill = 0;
            }
            if (topBlocksToFill > 0) {
                if (y >= 62) {
                    primer.func_177855_a(localZ, y, localX, topBlock);
                } else if (y >= 56 - dirtDepth) {
                    primer.func_177855_a(localZ, y, localX, fillerBlock);
                } else if (y >= 40) {
                    primer.func_177855_a(localZ, y, localX, fillerBlock2);
                } else if (y >= 5) {
                    primer.func_177855_a(localZ, y, localX, fillerBlock3);
                } else {
                    primer.func_177855_a(localZ, y, localX, Blocks.field_150351_n.func_176223_P());
                    dirtBlocksToFill = 0;
                }
                --topBlocksToFill;
                continue;
            }
            if (dirtBlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock);
                --dirtBlocksToFill;
                continue;
            }
            if (fill2BlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock2);
                --fill2BlocksToFill;
                continue;
            }
            if (fill3BlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock3);
                --fill3BlocksToFill;
                continue;
            }
            if (transitionBlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, transitionBlock);
                --transitionBlocksToFill;
                continue;
            }
            if (fill3BlocksToFill_1 > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock3);
                --fill3BlocksToFill_1;
                continue;
            }
            if (transitionBlocksToFill_1 > 0) {
                primer.func_177855_a(localZ, y, localX, transitionBlock1);
                --transitionBlocksToFill_1;
                continue;
            }
            if (fill3BlocksToFill_2 > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock3);
                --fill3BlocksToFill_2;
                continue;
            }
            if (fill4BlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock4);
                --fill4BlocksToFill;
                continue;
            }
            if (transitionBlocksToFill_2 > 0) {
                primer.func_177855_a(localZ, y, localX, transitionBlock2);
                --transitionBlocksToFill_2;
                continue;
            }
            if (fill4BlocksToFill_1 > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock4);
                --fill4BlocksToFill_1;
                continue;
            }
            if (transitionBlocksToFill_3 > 0) {
                primer.func_177855_a(localZ, y, localX, transitionBlock3);
                --transitionBlocksToFill_3;
                continue;
            }
            if (fill4BlocksToFill_2 > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock4);
                --fill4BlocksToFill_2;
                continue;
            }
            if (fill5BlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock5);
                --fill5BlocksToFill;
                continue;
            }
            if (transitionBlocksToFill_4 > 0) {
                primer.func_177855_a(localZ, y, localX, transitionBlock4);
                --transitionBlocksToFill_4;
                continue;
            }
            if (fill5BlocksToFill_1 > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock5);
                --fill5BlocksToFill_1;
                continue;
            }
            if (transitionBlocksToFill_5 > 0) {
                primer.func_177855_a(localZ, y, localX, transitionBlock5);
                --transitionBlocksToFill_5;
                continue;
            }
            if (fill5BlocksToFill_2 > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock5);
                --fill5BlocksToFill_2;
                continue;
            }
            if (fill6BlocksToFill > 0) {
                primer.func_177855_a(localZ, y, localX, fillerBlock6);
                --fill6BlocksToFill;
                continue;
            }
            if (transitionBlocksToFill_6 > 0) {
                primer.func_177855_a(localZ, y, localX, transitionBlock6);
                --transitionBlocksToFill_6;
                continue;
            }
            if (fill6BlocksToFill_1 <= 0) continue;
            primer.func_177855_a(localZ, y, localX, fillerBlock6);
            --fill6BlocksToFill_1;
        }
    }

    public static enum Type {
        NORMAL;

    }
}

