/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world.generation;

import com.conquestreforged.common.world.structure.CachedStructure;
import com.conquestreforged.common.world.structure.StructureManager;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public abstract class AbstractTreeGen
extends WorldGenAbstractTree {
    private static final Rotation[] rotations = Rotation.values();
    private static final Mirror[] mirrrors = Mirror.values();
    private final PlacementSettings placementSettings = new PlacementSettings();

    public AbstractTreeGen(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        ResourceLocation location = this.nextStructure(rand);
        CachedStructure structure = StructureManager.getInstance().get(location);
        if (structure.isPresent()) {
            Mirror mirror = this.nextMirror(rand);
            Rotation rotation = this.nextRotation(rand);
            PlacementSettings placement = this.getPlacementSettings().func_186220_a(rotation).func_186214_a(mirror);
            BlockPos target = structure.transformPosition(position, placement);
            if (this.canPlaceOn(worldIn, target.func_177977_b())) {
                BlockPos placementPosition = structure.getPositionForPlacement(target);
                structure.apply(worldIn, placementPosition, placement);
                return true;
            }
        }
        return false;
    }

    public PlacementSettings getPlacementSettings() {
        return this.placementSettings;
    }

    public Rotation nextRotation(Random random) {
        return rotations[random.nextInt(rotations.length)];
    }

    public Mirror nextMirror(Random random) {
        return mirrrors[random.nextInt(mirrrors.length)];
    }

    public abstract ResourceLocation nextStructure(Random var1);

    public abstract boolean canPlaceOn(World var1, BlockPos var2);
}

