/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world.generation;

import com.conquestreforged.common.util.WeightedList;
import com.conquestreforged.common.world.generation.AbstractTreeGen;
import com.conquestreforged.common.world.structure.CachedStructure;
import com.conquestreforged.common.world.structure.StructureManager;
import com.conquestreforged.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class WorldCalciteCave
extends AbstractTreeGen {
    private static final WeightedList<ResourceLocation> trees = WeightedList.create().add(new ResourceLocation("cave"), 1.0);

    public WorldCalciteCave(boolean notify) {
        super(notify);
    }

    @Override
    public ResourceLocation nextStructure(Random random) {
        return trees.next(random);
    }

    @Override
    public boolean canPlaceOn(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150354_m || block == Blocks.field_150346_d || block == ModBlocks.sand_full_1 || block == ModBlocks.ground_full_2 || block == ModBlocks.ground_full_3;
    }

    @Override
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        ResourceLocation location = this.nextStructure(rand);
        CachedStructure structure = StructureManager.getInstance().get(location);
        if (structure.isPresent()) {
            Mirror mirror = this.nextMirror(rand);
            Rotation rotation = this.nextRotation(rand);
            PlacementSettings placement = this.getPlacementSettings().func_186220_a(rotation).func_186214_a(mirror);
            BlockPos target = structure.transformPosition(position, placement);
            if (this.canPlaceOn(worldIn, target.func_177977_b())) {
                BlockPos placementPosition = structure.getPositionForPlacement(target.func_177979_c(50));
                structure.apply(worldIn, placementPosition, placement);
                return true;
            }
        }
        return false;
    }

    protected boolean func_150523_a(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151579_a || material == Material.field_151576_e || material == Material.field_151584_j || blockType == Blocks.field_150349_c || blockType == Blocks.field_150346_d || blockType == Blocks.field_150364_r || blockType == Blocks.field_150363_s || blockType == Blocks.field_150345_g || blockType == Blocks.field_150395_bd;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos) || this.func_150523_a(state.func_177230_c());
    }
}

