/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world.generation;

import com.conquestreforged.common.util.WeightedList;
import com.conquestreforged.common.world.generation.AbstractTreeGen;
import com.conquestreforged.common.world.structure.CachedStructure;
import com.conquestreforged.common.world.structure.StructureManager;
import com.conquestreforged.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class WorldCoral
extends AbstractTreeGen {
    private static final WeightedList<ResourceLocation> trees = WeightedList.create().add(new ResourceLocation("coral_brain"), 1.0).add(new ResourceLocation("coral_anemone"), 1.0).add(new ResourceLocation("coral_blue"), 1.0);

    public WorldCoral(boolean notify) {
        super(notify);
    }

    @Override
    public ResourceLocation nextStructure(Random random) {
        return trees.next(random);
    }

    @Override
    public boolean canPlaceOn(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return (block == Blocks.field_150354_m || block == ModBlocks.sand_full_1) & world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150355_j;
    }

    @Override
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        ResourceLocation location = this.nextStructure(rand);
        CachedStructure structure = StructureManager.getInstance().get(location);
        if (structure.isPresent()) {
            Mirror mirror = this.nextMirror(rand);
            Rotation rotation = this.nextRotation(rand);
            PlacementSettings placement = this.getPlacementSettings().func_186220_a(rotation).func_186214_a(mirror);
            BlockPos target = structure.transformPosition(position, placement);
            if (this.canPlaceOn(worldIn, target.func_177977_b())) {
                BlockPos placementPosition = structure.getPositionForPlacement(target.func_177979_c(1));
                structure.apply(worldIn, placementPosition, placement);
                return true;
            }
        }
        return false;
    }

    protected boolean func_150523_a(Block blockType) {
        Material material = blockType.func_176223_P().func_185904_a();
        return material == Material.field_151586_h || material == Material.field_151595_p;
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.func_150523_a(state.func_177230_c());
    }
}

