/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world.structure;

import jline.internal.Nullable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class CachedStructure {
    private static final CachedStructure EMPTY = new CachedStructure();
    private final Template template;
    private final BlockPos offset;

    private CachedStructure() {
        this.template = new Template();
        this.offset = BlockPos.field_177992_a;
    }

    private CachedStructure(Template template, BlockPos offset) {
        this.template = template;
        this.offset = offset;
    }

    public void apply(World world, BlockPos position, PlacementSettings settings) {
        this.template.func_186253_b(world, position, settings);
    }

    public Template getTemplate() {
        return this.template;
    }

    public BlockPos getOffset() {
        return this.offset;
    }

    public BlockPos getPositionForPlacement(BlockPos position) {
        return position.func_177973_b((Vec3i)this.getOffset());
    }

    public BlockPos transformPosition(BlockPos in, PlacementSettings settings) {
        return this.transformPosition(in, settings.func_186212_b(), settings.func_186215_c());
    }

    public BlockPos transformPosition(BlockPos in, @Nullable Mirror mirror, @Nullable Rotation rotation) {
        return this.template.func_189961_a(in, mirror, rotation);
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    public static CachedStructure empty() {
        return EMPTY;
    }

    public static CachedStructure of(Template template, BlockPos offset) {
        return template == null ? EMPTY : new CachedStructure(template, offset);
    }
}

