/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.common.world.structure;

import com.conquestreforged.common.world.structure.CachedStructure;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.structure.template.Template;
import org.apache.commons.io.IOUtils;

public class StructureManager {
    private static final StructureManager instance = new StructureManager();
    private final Map<ResourceLocation, CachedStructure> cache = new HashMap<ResourceLocation, CachedStructure>();

    public CachedStructure get(ResourceLocation location) {
        CachedStructure structure = this.cache.getOrDefault(location, null);
        if (structure == null) {
            structure = StructureManager.readStructure(location);
            this.cache.put(location, structure);
        }
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedStructure readStructure(ResourceLocation id) {
        CachedStructure cachedStructure;
        String domain = id.func_110624_b();
        String path = id.func_110623_a();
        InputStream inputstream = null;
        try {
            inputstream = MinecraftServer.class.getResourceAsStream("/assets/" + domain + "/structures/" + path + ".nbt");
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)inputstream);
            if (!nbttagcompound.func_150297_b("DataVersion", 99)) {
                nbttagcompound.func_74768_a("DataVersion", 500);
            }
            Template template = new Template();
            template.func_186256_b(nbttagcompound);
            BlockPos offset = StructureManager.calcOffset(template.func_186259_a(), nbttagcompound);
            cachedStructure = CachedStructure.of(template, offset);
        }
        catch (Throwable var10) {
            try {
                CachedStructure cachedStructure2 = CachedStructure.empty();
                return cachedStructure2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(inputstream);
            }
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        return cachedStructure;
    }

    private static BlockPos calcOffset(BlockPos size, NBTTagCompound root) {
        BlockPos center = new BlockPos(size.func_177958_n() / 2, 0, size.func_177952_p() / 2);
        BlockPos min = BlockPos.field_177992_a;
        double dist2 = -1.0;
        NBTTagList blocks = root.func_150295_c("blocks", 10);
        for (int i = 0; i < blocks.func_74745_c(); ++i) {
            NBTTagCompound block = blocks.func_150305_b(i);
            NBTTagList pos = block.func_150295_c("pos", 3);
            int x = pos.func_186858_c(0);
            int y = pos.func_186858_c(1);
            int z = pos.func_186858_c(2);
            if (min == BlockPos.field_177992_a || y < min.func_177956_o()) {
                min = new BlockPos(x, y, z);
                dist2 = center.func_177957_d((double)x, 0.0, (double)z);
                continue;
            }
            if (y != min.func_177956_o() || !(center.func_177957_d((double)x, 0.0, (double)z) < dist2)) continue;
            min = new BlockPos(x, y, z);
            dist2 = center.func_177957_d((double)x, 0.0, (double)z);
        }
        return new BlockPos(min.func_177958_n(), min.func_177956_o(), min.func_177952_p());
    }

    public static StructureManager getInstance() {
        return instance;
    }
}

