/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.connect;

import com.conquestreforged.connect.gui.MultiplayerGui;
import com.conquestreforged.connect.server.ServerEntry;
import com.conquestreforged.connect.server.ServerList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="connect", clientSideOnly=true, canBeDeactivated=true, acceptedMinecraftVersions="[1.12.2]")
public class Connect {
    public static final String MODID = "connect";
    public static final String API_URL = "https://promo.conquestreforged.com/api/server";
    public static final String APPLY_URL = "https://promo.conquestreforged.com/apply";
    private final ServerList serverList = new ServerList();
    private final KeyBinding keybind = new KeyBinding("connect.bind.open", 25, "Conquest Reforged");
    private final int buttonId = -914712468;

    public Connect() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)this.keybind);
        this.serverList.startPolling();
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMultiplayer) {
            GuiMainMenu parent = null;
            if (Minecraft.func_71410_x().field_71441_e == null) {
                parent = new GuiMainMenu();
            }
            event.setGui((GuiScreen)new MultiplayerGui((GuiScreen)parent, this.serverList));
        }
    }

    @SubscribeEvent
    public void guiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiIngameMenu) {
            List list = event.getButtonList();
            GuiButton lowest = null;
            for (GuiButton button : list) {
                if (lowest != null && button.field_146129_i <= lowest.field_146129_i) continue;
                lowest = button;
            }
            if (lowest != null) {
                GuiButton btServers = new GuiButton(-914712468, 0, 0, I18n.func_135052_a((String)"connect.ui.button.servers", (Object[])new Object[0]));
                btServers.field_146121_g = lowest.field_146121_g;
                btServers.field_146120_f = lowest.field_146120_f;
                btServers.field_146129_i = lowest.field_146129_i;
                btServers.field_146128_h = lowest.field_146128_h;
                lowest.field_146129_i = btServers.field_146129_i + btServers.field_146121_g + 5;
                list.add(btServers);
            }
        }
    }

    @SubscribeEvent
    public void guiAction(GuiScreenEvent.ActionPerformedEvent event) {
        if (event.getButton().field_146127_k == -914712468) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new MultiplayerGui(event.getGui(), this.serverList));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (this.keybind.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new MultiplayerGui(null, this.serverList));
        }
    }

    public static void disconnectServer() {
        WorldClient client = Minecraft.func_71410_x().field_71441_e;
        if (client != null) {
            client.func_72882_A();
        }
    }

    public static void connect(GuiScreen parent, ServerEntry server) {
        FMLClientHandler.instance().connectToServer(parent, server.getData());
    }
}

