/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.connect;

import com.conquestreforged.connect.server.ServerEntry;
import com.conquestreforged.connect.server.ServerList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.dags.http.client.Client;
import me.dags.http.client.Response;
import me.dags.http.client.ResponseBody;

public class Poller
extends Thread {
    private final ServerList serverList;

    public Poller(ServerList serverList) {
        this.serverList = serverList;
    }

    @Override
    public void run() {
        while (true) {
            LinkedList<ServerEntry> entries = new LinkedList<ServerEntry>();
            try {
                this.getServers(entries);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.serverList.setServers(entries);
            try {
                Thread.sleep(TimeUnit.MINUTES.toMillis(5L));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void getServers(List<ServerEntry> entries) throws IOException {
        try (Response response = Client.get("https://promo.conquestreforged.com/api/server");){
            if (response == null) {
                return;
            }
            ResponseBody body = response.body();
            if (body == null) {
                return;
            }
            try (Reader reader = body.charStream();){
                JsonObject root = new JsonParser().parse(reader).getAsJsonObject();
                for (Map.Entry e : root.entrySet()) {
                    String[] split;
                    JsonObject server = ((JsonElement)e.getValue()).getAsJsonObject();
                    String name = server.get("name").getAsString();
                    String ip = server.get("ip").getAsString();
                    String keywords = server.get("tags").getAsString();
                    HashSet<String> tags = new HashSet<String>();
                    for (String s : split = keywords.split(",")) {
                        tags.add(s.trim().toLowerCase());
                    }
                    ServerEntry entry = new ServerEntry(name, ip, tags);
                    entries.add(entry);
                }
            }
        }
    }
}

