/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.connect.gui;

import com.conquestreforged.connect.gui.Screen;
import com.conquestreforged.connect.gui.SuggestionScreen;
import com.conquestreforged.connect.gui.UserServerScreen;
import com.conquestreforged.connect.gui.component.DirectionButton;
import com.conquestreforged.connect.server.ServerEntry;
import com.conquestreforged.connect.server.ServerList;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;

public class MultiplayerGui
extends GuiScreen {
    private final List<ServerEntry> servers;
    private final GuiScreen parent;
    private final UserServerScreen home;
    private final SuggestionScreen suggestions;
    private final DirectionButton next = DirectionButton.right(101, 0, 0, 24);
    private final DirectionButton previous = DirectionButton.left(102, 0, 0, 24);
    private int pageIndex = -1;

    public MultiplayerGui(GuiScreen parent, ServerList list) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.parent = parent;
        this.home = new UserServerScreen(parent, this.field_146297_k);
        this.suggestions = new SuggestionScreen(this, parent);
        this.servers = list.getServers();
        Collections.addAll(this.field_146292_n, this.next, this.previous);
    }

    public void addServer(ServerEntry serverEntry) {
        this.home.func_146795_p().func_78849_a(serverEntry.getData());
        this.home.func_146795_p().func_78855_b();
        this.field_146297_k.func_147108_a((GuiScreen)new GuiMultiplayer(this.parent));
    }

    private Screen getCurrentScreen() {
        if (this.pageIndex == -1) {
            return this.home;
        }
        return this.suggestions;
    }

    public void func_73866_w_() {
        this.home.func_73866_w_();
        this.suggestions.init();
        this.field_146292_n.clear();
        this.field_146292_n.add(this.previous);
        this.field_146292_n.add(this.next);
        this.previous.field_146128_h = 5;
        this.previous.field_146129_i = this.field_146295_m / 2 - this.previous.field_146121_g;
        this.next.field_146128_h = this.field_146294_l - 5 - this.next.field_146120_f;
        this.next.field_146129_i = this.field_146295_m / 2 - this.next.field_146121_g;
        this.suggestions.update(this.servers);
    }

    public void func_146280_a(Minecraft mcIn, int w, int h) {
        super.func_146280_a(this.field_146297_k, w, h);
        this.home.func_146280_a(mcIn, w, h);
        this.suggestions.setResolution(mcIn, w, h);
        this.pageIndex = -1;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.getCurrentScreen().update();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.previous.field_146125_m = this.pageIndex > -1;
        this.next.field_146125_m = this.pageIndex + 1 < this.suggestions.getPageCount();
        this.getCurrentScreen().draw(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.getCurrentScreen().mouseInput();
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        this.getCurrentScreen().keyboardInput();
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.next && this.pageIndex + 1 < this.suggestions.getPageCount()) {
            this.suggestions.setPageIndex(++this.pageIndex);
        }
        if (button == this.previous) {
            if (this.pageIndex > 0) {
                this.suggestions.setPageIndex(--this.pageIndex);
            } else {
                --this.pageIndex;
            }
        }
    }

    public void func_146283_a(List<String> lines, int mx, int my) {
        super.func_146283_a(lines, mx, my);
    }
}

