/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.connect.gui;

import com.conquestreforged.connect.Connect;
import com.conquestreforged.connect.gui.MultiplayerGui;
import com.conquestreforged.connect.gui.Screen;
import com.conquestreforged.connect.gui.component.PageManager;
import com.conquestreforged.connect.gui.component.SearchResponder;
import com.conquestreforged.connect.gui.component.ServerListEntry;
import com.conquestreforged.connect.gui.component.SuggestionList;
import com.conquestreforged.connect.gui.component.Title;
import com.conquestreforged.connect.server.ServerEntry;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;

public class SuggestionScreen
extends GuiMultiplayer
implements Screen {
    private static final SuggestionList EMPTY = new SuggestionList(Collections.emptyList());
    private static final int ZERO = 0;
    private static final int SEARCH_WIDTH = 308;
    private static final int SEARCH_HEIGHT = 20;
    private final MultiplayerGui root;
    private final PageManager pageManager;
    private final Title title;
    private final GuiButton btnAddServer = new GuiButton(1, 0, 0, 100, 20, I18n.func_135052_a((String)"connect.ui.button.add", (Object[])new Object[0]));
    private final GuiButton btnRandServer = new GuiButton(2, 0, 0, 100, 20, I18n.func_135052_a((String)"connect.ui.button.random", (Object[])new Object[0]));
    private final GuiButton btnJoinServer = new GuiButton(3, 0, 0, 100, 20, I18n.func_135052_a((String)"connect.ui.button.join", (Object[])new Object[0]));
    private final GuiTextField search;
    private int selected;
    private boolean isFiltered;
    private SuggestionList suggestions;

    public SuggestionScreen(MultiplayerGui root, GuiScreen parent) {
        super(parent);
        this.search = new GuiTextField(4, Minecraft.func_71410_x().field_71466_p, 0, 0, 308, 20);
        this.selected = -1;
        this.isFiltered = false;
        this.suggestions = EMPTY;
        this.root = root;
        this.field_146297_k = Minecraft.func_71410_x();
        this.field_146289_q = this.field_146297_k.field_71466_p;
        this.pageManager = new PageManager(this, 4);
        this.title = new Title(this.field_146297_k, 0xFFFFFF, 4359924, "connect.ui.suggestions.title", "connect.ui.suggestions.tooltip", () -> {
            try {
                Desktop.getDesktop().browse(new URI("https://promo.conquestreforged.com/apply"));
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
            }
        });
    }

    public int getPageCount() {
        return this.isFiltered ? 1 : this.pageManager.getPageCount();
    }

    public void setPageIndex(int pageIndex) {
        this.setSuggestions(this.pageManager.getPage(pageIndex));
    }

    public void update(List<ServerEntry> serverEntries) {
        this.pageManager.update(serverEntries);
    }

    public void doSearch(Predicate<ServerEntry> filter) {
        this.isFiltered = filter != SearchResponder.ANY;
        this.setSuggestions(this.pageManager.getFilteredServers(filter));
    }

    public void setSuggestions(SuggestionList suggestions) {
        this.suggestions = suggestions;
        this.suggestions.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 64);
    }

    @Override
    public GuiScreen self() {
        return this;
    }

    @Override
    public void init() {
        super.func_73866_w_();
        this.search.func_175207_a((GuiPageButtonList.GuiResponder)new SearchResponder(this));
    }

    @Override
    public void setResolution(Minecraft mc, int w, int h) {
        super.func_146280_a(mc, w, h);
        this.pageManager.setSizes(32, 64, 36);
        this.suggestions.func_148122_a(w, h, 32, h - 64);
        this.search.field_146209_f = this.field_146294_l / 2 - this.search.field_146218_h / 2 + 3;
        this.search.field_146210_g = this.field_146295_m - 28;
        int center = this.field_146294_l / 2;
        SuggestionScreen.setPos(this.btnJoinServer, center - 154, this.field_146295_m - 52);
        SuggestionScreen.setPos(this.btnAddServer, center - 50, this.field_146295_m - 52);
        SuggestionScreen.setPos(this.btnRandServer, center + 54, this.field_146295_m - 52);
        this.field_146292_n.clear();
        Collections.addAll(this.field_146292_n, this.btnJoinServer, this.btnAddServer, this.btnRandServer);
        ScaledResolution resolution = new ScaledResolution(mc);
        this.pageManager.setResolution(resolution);
        this.setSuggestions(this.pageManager.getPage(0));
        this.title.setScreenSize(w, h);
    }

    @Override
    public void update() {
    }

    public void func_146794_g() {
    }

    @Override
    public void draw(int mx, int my, float ticks) {
        super.func_146276_q_();
        this.suggestions.func_148128_a(mx, my, ticks);
        this.search.func_146194_f();
        for (GuiButton button : this.field_146292_n) {
            button.func_191745_a(this.field_146297_k, mx, my, ticks);
        }
        this.title.draw(this, mx, my);
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.search.func_146201_a(typedChar, keyCode);
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.suggestions.func_148179_a(mouseX, mouseY, mouseButton);
        this.search.func_146192_a(mouseX, mouseY, mouseButton);
        this.title.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.suggestions.func_148181_b(mouseX, mouseY, state);
    }

    @Override
    public void drawHoverText(List<String> lines, int mx, int my) {
        super.func_146283_a(lines, mx, my);
    }

    public void func_146790_a(int index) {
        ServerListEntry selected = this.suggestions.getListEntry(index);
        this.btnJoinServer.field_146124_l = false;
        this.btnAddServer.field_146124_l = false;
        this.selected = -1;
        if (selected != null) {
            this.btnJoinServer.field_146124_l = true;
            this.btnAddServer.field_146124_l = true;
            this.selected = index;
        }
        this.suggestions.setSelected(index);
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button == this.btnJoinServer) {
                this.func_146796_h();
            }
            if (button == this.btnAddServer && this.selected > -1) {
                ServerListEntry server = this.suggestions.getListEntry(this.selected);
                this.root.addServer(server.getServer());
            }
            if (button == this.btnRandServer) {
                this.isFiltered = true;
                this.setSuggestions(this.pageManager.getRandomServer());
            }
        }
    }

    public void func_146796_h() {
        if (this.selected > -1) {
            ServerListEntry server = this.suggestions.getListEntry(this.selected);
            Connect.disconnectServer();
            Connect.connect(this.root, server.getServer());
        }
    }

    @Override
    public void mouseInput() throws IOException {
        super.func_146274_d();
        this.suggestions.func_178039_p();
    }

    private static void setPos(GuiButton button, int left, int top) {
        button.field_146128_h = left;
        button.field_146129_i = top;
    }
}

