/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.connect.gui.component;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class DirectionButton
extends GuiButton {
    private static final ResourceLocation HOVERED = new ResourceLocation("connect", "textures/gui/arrow_hovered.png");
    private static final ResourceLocation NORMAL = new ResourceLocation("connect", "textures/gui/arrow_normal.png");
    private static boolean used = false;
    private final float tu0;
    private final float tu1;
    private final float tv0;
    private final float tv1;
    private final float inc;
    private final boolean flash;
    private final Stopwatch timer = Stopwatch.createStarted();

    private DirectionButton(int buttonId, int x, int y, int size, boolean flip) {
        super(buttonId, x, y, "");
        this.field_146120_f = size;
        this.field_146121_g = size;
        this.flash = !flip;
        this.tu0 = flip ? 1.0f : 0.0f;
        this.tu1 = flip ? 0.0f : 1.0f;
        this.inc = flip ? -0.5f : 0.5f;
        this.tv0 = 0.0f;
        this.tv1 = 1.0f;
    }

    public boolean func_146116_c(Minecraft mc, int mx, int my) {
        if (super.func_146116_c(mc, mx, my)) {
            used = true;
            return true;
        }
        return false;
    }

    public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float ticks) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            float color = this.field_146123_n ? 0.9f : 0.8f;
            ResourceLocation texture = this.getTexture();
            mc.func_110434_K().func_110577_a(texture);
            GlStateManager.func_179131_c((float)color, (float)color, (float)color, (float)color);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            float z = 0.0f;
            float x = this.field_146123_n ? (float)this.field_146128_h + this.inc : (float)this.field_146128_h;
            float y = this.field_146129_i;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)x, (double)(y + (float)this.field_146121_g), (double)z).func_187315_a((double)this.tu0, (double)this.tv1).func_181675_d();
            buffer.func_181662_b((double)(x + (float)this.field_146120_f), (double)(y + (float)this.field_146121_g), (double)z).func_187315_a((double)this.tu1, (double)this.tv1).func_181675_d();
            buffer.func_181662_b((double)(x + (float)this.field_146120_f), (double)y, (double)z).func_187315_a((double)this.tu1, (double)this.tv0).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)this.tu0, (double)this.tv0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    private ResourceLocation getTexture() {
        long elapsed;
        if (this.field_146123_n) {
            return HOVERED;
        }
        if (used) {
            return NORMAL;
        }
        if (this.flash && (elapsed = this.timer.elapsed(TimeUnit.MILLISECONDS)) > 500L) {
            if (elapsed > 1000L) {
                this.timer.reset().start();
            }
            return HOVERED;
        }
        return NORMAL;
    }

    public static DirectionButton left(int id, int x, int y, int size) {
        return new DirectionButton(id, x, y, size, true);
    }

    public static DirectionButton right(int id, int x, int y, int size) {
        return new DirectionButton(id, x, y, size, false);
    }
}

