/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.connect.gui.component;

import com.conquestreforged.connect.gui.component.ServerListEntry;
import com.conquestreforged.connect.gui.component.SuggestionList;
import com.conquestreforged.connect.server.ServerEntry;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.ScaledResolution;

public class PageManager {
    private static final Random RANDOM = new Random();
    private final GuiMultiplayer parent;
    private final List<ServerListEntry> servers = Lists.newArrayList();
    private int marginTop;
    private int marginBottom;
    private int elementHeight;
    private int pageSize;

    public PageManager(GuiMultiplayer parent, int pageSize) {
        this.pageSize = pageSize;
        this.parent = parent;
    }

    public void setSizes(int marginTop, int marginBottom, int elementHeight) {
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
        this.elementHeight = elementHeight;
    }

    public void setResolution(ScaledResolution resolution) {
        this.pageSize = (resolution.func_78328_b() - this.marginTop - this.marginBottom) / this.elementHeight;
    }

    public SuggestionList getPage(int page) {
        return new SuggestionList(this.getServers(page));
    }

    public int getPageCount() {
        int div = this.servers.size() / this.pageSize;
        int rem = this.servers.size() % this.pageSize;
        return div + (rem > 0 ? 1 : 0);
    }

    public SuggestionList getRandomServer() {
        List<ServerListEntry> list = Collections.emptyList();
        if (!this.servers.isEmpty()) {
            ServerListEntry entry = this.servers.get(RANDOM.nextInt(this.servers.size()));
            list = Collections.singletonList(entry);
        }
        return new SuggestionList(list);
    }

    public SuggestionList getFilteredServers(Predicate<ServerEntry> filter) {
        ArrayList<ServerListEntry> list = new ArrayList<ServerListEntry>(this.pageSize);
        for (ServerListEntry entry : this.servers) {
            if (!filter.test(entry.getServer())) continue;
            list.add(entry);
            if (list.size() < this.pageSize) continue;
            break;
        }
        return new SuggestionList(list);
    }

    private List<ServerListEntry> getServers(int page) {
        ArrayList<ServerListEntry> list = new ArrayList<ServerListEntry>(this.pageSize);
        for (int i = page * this.pageSize; i < this.servers.size(); ++i) {
            list.add(this.servers.get(i));
            if (list.size() >= this.pageSize) break;
        }
        return list;
    }

    public void update(List<ServerEntry> serverEntries) {
        this.servers.clear();
        for (ServerEntry entry : serverEntries) {
            this.servers.add(new ServerListEntry(this.parent, entry));
        }
    }
}

