/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.connect.gui.component;

import com.conquestreforged.connect.gui.SuggestionScreen;
import com.conquestreforged.connect.server.ServerEntry;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiPageButtonList;

public class SearchResponder
implements GuiPageButtonList.GuiResponder {
    public static final Predicate<ServerEntry> ANY = e -> true;
    private final SuggestionScreen suggestionPage;

    public SearchResponder(SuggestionScreen suggestionPage) {
        this.suggestionPage = suggestionPage;
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        if (!value.isEmpty()) {
            String[] tokens;
            StringBuilder sb = new StringBuilder(64);
            HashSet<String> tags = new HashSet<String>();
            for (String token : tokens = value.split(" ")) {
                if (token.startsWith("#")) {
                    String tag = token.substring(1).toLowerCase();
                    tags.add(tag);
                    continue;
                }
                sb.append("(.*").append(Pattern.quote(token)).append(")");
            }
            Pattern name = Pattern.compile(sb.toString(), 2);
            Filter filter = new Filter(name, tags);
            this.suggestionPage.doSearch(filter);
        } else {
            this.suggestionPage.doSearch(ANY);
        }
    }

    private static class Filter
    implements Predicate<ServerEntry> {
        private final Pattern name;
        private final Set<String> tags;

        private Filter(Pattern name, Set<String> tags) {
            this.name = name;
            this.tags = tags;
        }

        @Override
        public boolean test(ServerEntry entry) {
            return this.name.matcher(entry.getName()).find() && entry.getTags().containsAll(this.tags);
        }
    }
}

