/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.connect.gui.component;

import com.conquestreforged.connect.gui.Screen;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class Title {
    private final FontRenderer fontRenderer;
    private final String text;
    private final String tooltip;
    private final Runnable action;
    private final int color;
    private final int highlight;
    private int left;
    private int width;
    private int top = 20;
    private int height = 15;

    public Title(Minecraft minecraft, int color, int highlight, String text, String tooltip, Runnable action) {
        this.fontRenderer = minecraft.field_71466_p;
        this.text = text;
        this.tooltip = tooltip;
        this.highlight = highlight;
        this.color = color;
        this.action = action;
    }

    public Title setScreenSize(int screenWidth, int screenHeight) {
        String text = I18n.func_135052_a((String)this.text, (Object[])new Object[0]);
        this.width = this.fontRenderer.func_78256_a(text);
        this.left = screenWidth / 2 - this.width / 2;
        this.top = 20;
        this.height = 15;
        return this;
    }

    public void draw(Screen screen, int mx, int my) {
        boolean hovered = this.isHovered(mx, my);
        String text = I18n.func_135052_a((String)this.text, (Object[])new Object[0]);
        int color = hovered ? this.highlight : this.color;
        this.fontRenderer.func_175063_a(text, (float)this.left, (float)this.top, color);
        if (hovered) {
            String tooltip = I18n.func_135052_a((String)this.tooltip, (Object[])new Object[]{"https://promo.conquestreforged.com/apply"});
            List<String> lines = Arrays.asList(tooltip.split("\\\\n"));
            int longest = 0;
            for (String line : lines) {
                longest = Math.max(longest, this.fontRenderer.func_78256_a(line));
            }
            screen.drawHoverText(lines, mx - longest / 2, my + 30);
        }
    }

    public void mouseClicked(int mx, int my, int button) {
        if (button == 0 && this.isHovered(mx, my)) {
            this.action.run();
        }
    }

    public boolean isHovered(int mx, int my) {
        return mx >= this.left && mx <= this.left + this.width && my >= this.top && my <= this.top + this.height;
    }
}

