/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.init;

import com.conquestreforged.ConquestReforged;
import com.conquestreforged.common.data.DataProcessor;
import com.conquestreforged.common.data.DataProcessors;
import com.conquestreforged.common.data.block.harvest.HarvestProcessor;
import com.conquestreforged.common.data.block.seat.SeatProcessor;
import com.conquestreforged.common.util.AssetPack;
import com.google.common.collect.HashMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;

public class Data {
    public static void preRegisterProcessors() {
        DataProcessors.getInstance().register("drops", new HarvestProcessor());
        DataProcessors.getInstance().register("seats", new SeatProcessor());
    }

    public static void postRegisterData() {
        ModContainer container = FMLCommonHandler.instance().findContainerFor((Object)ConquestReforged.getInstance());
        try (AssetPack pack = new AssetPack(container.getSource());){
            HashMultimap<String, ResourceLocation> map = pack.getDataLocations();
            for (String type : map.keySet()) {
                Optional<DataProcessor> processor = DataProcessors.getInstance().getProcessor(type);
                if (!processor.isPresent()) {
                    System.out.printf("No processor present for data type: %s\n", type);
                    continue;
                }
                for (ResourceLocation location : map.get((Object)type)) {
                    System.out.printf("Processing %s data for: %s\n", type, location);
                    Data.loadData(pack, location, processor.get(), type);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadData(AssetPack pack, ResourceLocation location, DataProcessor processor, String dataType) {
        try (InputStream inputStream = pack.getData(dataType, location);
             InputStreamReader reader = new InputStreamReader(inputStream);){
            JsonElement json = new JsonParser().parse((Reader)reader);
            processor.process(location, json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

