/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.init;

import com.conquestreforged.common.world.biome.BiomeAlderSwamp;
import com.conquestreforged.common.world.biome.BiomeBambooForest;
import com.conquestreforged.common.world.biome.BiomeBeach;
import com.conquestreforged.common.world.biome.BiomeBirchForest;
import com.conquestreforged.common.world.biome.BiomeBirchForestFlowerPlain;
import com.conquestreforged.common.world.biome.BiomeBog;
import com.conquestreforged.common.world.biome.BiomeBoreal;
import com.conquestreforged.common.world.biome.BiomeColdBeach;
import com.conquestreforged.common.world.biome.BiomeDeciduousForest;
import com.conquestreforged.common.world.biome.BiomeDesert;
import com.conquestreforged.common.world.biome.BiomeJapanese;
import com.conquestreforged.common.world.biome.BiomeJungle;
import com.conquestreforged.common.world.biome.BiomeLoreinForest;
import com.conquestreforged.common.world.biome.BiomeMarsh;
import com.conquestreforged.common.world.biome.BiomeMediterranean;
import com.conquestreforged.common.world.biome.BiomeMesa;
import com.conquestreforged.common.world.biome.BiomeMoorland;
import com.conquestreforged.common.world.biome.BiomeMountains;
import com.conquestreforged.common.world.biome.BiomeOcean;
import com.conquestreforged.common.world.biome.BiomeOldGrowthForest;
import com.conquestreforged.common.world.biome.BiomeRedDesert;
import com.conquestreforged.common.world.biome.BiomeRiver;
import com.conquestreforged.common.world.biome.BiomeTundra;
import com.conquestreforged.common.world.biome.BiomeTundraMarsh;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBiomes {
    public static final BiomeBoreal BOREAL = new BiomeBoreal(BiomeBoreal.Type.NORMAL, new Biome.BiomeProperties("Boreal Forest").func_185398_c(0.2f).func_185400_d(0.2f).func_185410_a(0.25f).func_185395_b(0.4f).func_185411_b());
    public static final BiomeBoreal BOREAL_MEGA = new BiomeBoreal(BiomeBoreal.Type.MEGA, new Biome.BiomeProperties("Mega Boreal Forest").func_185398_c(0.2f).func_185400_d(0.2f).func_185410_a(0.25f).func_185395_b(0.8f).func_185411_b());
    public static final BiomeBirchForest BIRCHFOREST = new BiomeBirchForest(BiomeBirchForest.Type.NORMAL, new Biome.BiomeProperties("Birch Forest").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(0.6f).func_185395_b(0.4f));
    public static final BiomeMarsh MARSH = new BiomeMarsh(BiomeMarsh.Type.NORMAL, new Biome.BiomeProperties("Marsh").func_185398_c(-0.35f).func_185400_d(-1.0E-20f).func_185410_a(0.8f).func_185395_b(0.9f));
    public static final BiomeMoorland MOORLAND = new BiomeMoorland(BiomeMoorland.Type.NORMAL, new Biome.BiomeProperties("Moorland").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(0.8f).func_185395_b(0.4f));
    public static final BiomeLoreinForest LORIEN_FOREST = new BiomeLoreinForest(BiomeLoreinForest.Type.NORMAL, new Biome.BiomeProperties("Lorien Forest").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(0.6f).func_185395_b(0.4f));
    public static final BiomeBirchForestFlowerPlain BIRCHFOREST_FLOWERPLAIN = new BiomeBirchForestFlowerPlain(BiomeBirchForestFlowerPlain.Type.NORMAL, new Biome.BiomeProperties("Forest Flower Plain").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(0.8f).func_185395_b(0.4f));
    public static final BiomeTundra TUNDRA = new BiomeTundra(BiomeTundra.Type.NORMAL, new Biome.BiomeProperties("Tundra").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(0.0f).func_185395_b(0.4f).func_185411_b());
    public static final BiomeTundraMarsh TUNDRA_MARSH = new BiomeTundraMarsh(BiomeTundraMarsh.Type.NORMAL, new Biome.BiomeProperties("Tundra Marsh").func_185398_c(-0.35f).func_185400_d(-1.0E-20f).func_185410_a(0.25f).func_185395_b(0.4f));
    public static final BiomeAlderSwamp ALDER_SWAMP = new BiomeAlderSwamp(BiomeAlderSwamp.Type.NORMAL, new Biome.BiomeProperties("Alder Swamp").func_185398_c(-0.35f).func_185400_d(-1.0E-20f).func_185410_a(0.8f).func_185395_b(0.4f));
    public static final BiomeBog BOG = new BiomeBog(BiomeBog.Type.NORMAL, new Biome.BiomeProperties("Bog").func_185398_c(-0.35f).func_185400_d(-1.0E-20f).func_185410_a(0.8f).func_185395_b(0.4f));
    public static final BiomeBambooForest BAMBOO_FOREST = new BiomeBambooForest(BiomeBambooForest.Type.NORMAL, new Biome.BiomeProperties("Bamboo Forest").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(0.6f).func_185395_b(0.6f));
    public static final BiomeDeciduousForest DECIDUOUS_FOREST = new BiomeDeciduousForest(BiomeDeciduousForest.Type.NORMAL, new Biome.BiomeProperties("Deciduous Forest").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(0.6f).func_185395_b(0.6f));
    public static final BiomeDesert DESERT = new BiomeDesert(new Biome.BiomeProperties("Desert").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(2.0f).func_185396_a());
    public static final BiomeRedDesert RED_DESERT = new BiomeRedDesert(new Biome.BiomeProperties("Red Desert").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(2.0f).func_185396_a());
    public static final BiomeJapanese JAPANESE_FOREST = new BiomeJapanese(BiomeJapanese.Type.NORMAL, new Biome.BiomeProperties("Japanese Forest").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(0.6f).func_185395_b(0.6f));
    public static final BiomeJungle JUNGLE = new BiomeJungle(BiomeJungle.Type.NORMAL, new Biome.BiomeProperties("Jungle").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(0.95f).func_185395_b(1.0f));
    public static final BiomeMediterranean MEDITERRANEAN = new BiomeMediterranean(BiomeMediterranean.Type.NORMAL, new Biome.BiomeProperties("Mediterranean").func_185398_c(0.125f).func_185400_d(0.05f).func_185410_a(0.8f).func_185395_b(0.2f));
    public static final BiomeMesa MESA_EXTREME = new BiomeMesa(true, true, new Biome.BiomeProperties("Mesa Extreme").func_185398_c(0.5f).func_185400_d(0.3f).func_185410_a(2.0f).func_185396_a());
    public static final BiomeMountains MOUNTAIN = new BiomeMountains(BiomeMountains.Type.NORMAL, new Biome.BiomeProperties("Mountains").func_185398_c(1.0f).func_185400_d(0.5f).func_185410_a(0.2f).func_185395_b(0.2f));
    public static final BiomeOldGrowthForest OLDGROWTH_FOREST = new BiomeOldGrowthForest(BiomeOldGrowthForest.Type.NORMAL, new Biome.BiomeProperties("Old Growth Forest").func_185398_c(0.2f).func_185400_d(0.1f).func_185410_a(0.6f).func_185395_b(0.6f));
    public static final BiomeBeach BEACH = new BiomeBeach(new Biome.BiomeProperties("Beach").func_185398_c(-0.35f).func_185400_d(-1.0E-16f).func_185410_a(0.6f).func_185395_b(0.4f));
    public static final BiomeColdBeach COLD_BEACH = new BiomeColdBeach(new Biome.BiomeProperties("Cold Beach").func_185398_c(-0.35f).func_185400_d(-1.0E-16f).func_185410_a(0.05f).func_185395_b(0.3f).func_185411_b());
    public static final BiomeOcean OCEAN_MOD = new BiomeOcean(new Biome.BiomeProperties("Ocean").func_185398_c(-1.0f).func_185400_d(0.11f));
    public static final BiomeRiver RIVER_MOD = new BiomeRiver(new Biome.BiomeProperties("River").func_185398_c(-0.5f).func_185400_d(0.01f));

    public static void preRegisterBiomes() {
        ModBiomes.removeOtherBiomes();
        ModBiomes.registerBiome(OCEAN_MOD, "ocean", BiomeManager.BiomeType.WARM, 10, false, false, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.WATER);
        ModBiomes.registerBiome(BOREAL, "boreal_forest", BiomeManager.BiomeType.COOL, 7, false, true, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(BOREAL_MEGA, "mega_boreal_forest", BiomeManager.BiomeType.COOL, 5, false, true, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(BIRCHFOREST, "birch_forest", BiomeManager.BiomeType.WARM, 7, false, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(BIRCHFOREST_FLOWERPLAIN, "forest_flower_plain", BiomeManager.BiomeType.WARM, 7, true, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiome(MARSH, "marsh", BiomeManager.BiomeType.WARM, 7, true, true, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiome(MOORLAND, "moorland", BiomeManager.BiomeType.WARM, 7, true, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiome(LORIEN_FOREST, "lorein_forest", BiomeManager.BiomeType.WARM, 7, false, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(TUNDRA, "tundra", BiomeManager.BiomeType.ICY, 7, true, true, BiomeDictionary.Type.COLD, BiomeDictionary.Type.PLAINS);
        ModBiomes.registerBiome(TUNDRA_MARSH, "tundra_marsh", BiomeManager.BiomeType.COOL, 7, true, true, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiome(ALDER_SWAMP, "alder_swamp", BiomeManager.BiomeType.WARM, 7, false, true, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiome(BOG, "bog", BiomeManager.BiomeType.WARM, 7, true, true, BiomeDictionary.Type.WET, BiomeDictionary.Type.SWAMP);
        ModBiomes.registerBiome(BAMBOO_FOREST, "bamboo_forest", BiomeManager.BiomeType.WARM, 7, false, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(DECIDUOUS_FOREST, "deciduous_forest", BiomeManager.BiomeType.WARM, 7, false, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(DESERT, "desert_mod", BiomeManager.BiomeType.DESERT, 7, false, true, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
        ModBiomes.registerBiome(RED_DESERT, "red_desert", BiomeManager.BiomeType.DESERT, 7, false, true, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
        ModBiomes.registerBiome(JAPANESE_FOREST, "japanese_forest", BiomeManager.BiomeType.WARM, 4, false, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(JUNGLE, "jungle_mod", BiomeManager.BiomeType.WARM, 7, false, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH);
        ModBiomes.registerBiome(MEDITERRANEAN, "mediterranean", BiomeManager.BiomeType.WARM, 7, false, true, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiome(MESA_EXTREME, "mesa_extreme_mod", BiomeManager.BiomeType.DESERT, 7, false, true, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
        ModBiomes.registerBiome(MOUNTAIN, "mountains", BiomeManager.BiomeType.COOL, 7, false, true, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS);
        ModBiomes.registerBiome(OLDGROWTH_FOREST, "oldgrowth_forest", BiomeManager.BiomeType.WARM, 7, false, true, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.FOREST);
        ModBiomes.registerBiome(BEACH, "beach_mod", BiomeManager.BiomeType.WARM, 7, false, false, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.DRY);
        ModBiomes.registerBiome(COLD_BEACH, "cold_beach_mod", BiomeManager.BiomeType.COOL, 7, false, false, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
        ModBiomes.registerBiome(RIVER_MOD, "river", BiomeManager.BiomeType.WARM, 7, false, false, BiomeDictionary.Type.RIVER, BiomeDictionary.Type.WATER);
    }

    private static void registerBiome(Biome biome, String nameIn, BiomeManager.BiomeType type, int weight, boolean villages, boolean strongholds, BiomeDictionary.Type ... types) {
        biome.setRegistryName(new ResourceLocation("conquest", nameIn));
        ForgeRegistries.BIOMES.register((IForgeRegistryEntry)biome);
        BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])types);
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
        BiomeManager.addSpawnBiome((Biome)biome);
        if (villages) {
            BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
        }
        if (strongholds) {
            BiomeManager.addStrongholdBiome((Biome)biome);
        }
    }

    private static void removeOtherBiomes() {
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            for (BiomeManager.BiomeEntry entry : BiomeManager.getBiomes((BiomeManager.BiomeType)type)) {
                BiomeManager.removeBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)entry);
            }
        }
    }
}

