/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.init.block;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.init.block.BlockInfo;
import com.conquestreforged.init.block.MissingModBlockConstructorException;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Map;

public class BlockFactory {
    private static BlockFactory instance;
    private final Map<String, Constructor<? extends ModBlock>> types;

    private BlockFactory() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.populate((ImmutableMap.Builder<String, Constructor<? extends ModBlock>>)builder, classLoader, "com.conquestreforged.common.block");
        this.populate((ImmutableMap.Builder<String, Constructor<? extends ModBlock>>)builder, classLoader, "com.conquestreforged.common.blockmeta");
        this.types = builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populate(ImmutableMap.Builder<String, Constructor<? extends ModBlock>> builder, ClassLoader classLoader, String route) {
        try {
            for (ClassPath.ClassInfo info : ClassPath.from((ClassLoader)classLoader).getTopLevelClasses(route)) {
                try {
                    Class<?> clazz = Class.forName(info.getName());
                    if (clazz.isInterface() || !ModBlock.class.isAssignableFrom(clazz)) continue;
                    Class<?> type = clazz;
                    Constructor<?> constructor = type.getConstructor(BlockInfo.class);
                    builder.put((Object)type.getSimpleName(), constructor);
                    builder.put((Object)type.getSimpleName().toLowerCase(), constructor);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    throw new MissingModBlockConstructorException(info.getName());
                    return;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Constructor<? extends ModBlock> getConstructor(String name) {
        return BlockFactory.getInstance().types.get(name);
    }

    public static BlockFactory getInstance() {
        if (instance == null) {
            instance = new BlockFactory();
        }
        return instance;
    }
}

