/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.init.block;

import com.conquestreforged.common.ModBlock;
import com.conquestreforged.common.util.FieldUtil;
import com.conquestreforged.common.util.StateMatcher;
import com.conquestreforged.init.block.BlockFactory;
import com.conquestreforged.init.block.ConstRegistry;
import com.conquestreforged.init.block.MissingBlockMetaException;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.dags.config.Mapper;
import me.dags.config.style.Default;
import me.dags.config.style.Style;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;

@Style(ignoreEmpty=true, breaks=0, indent=2, comments=false, override=true)
public class BlockInfo {
    private static final Mapper<BlockInfo> MAPPER = Mapper.of(BlockInfo.class);
    private static final ConstRegistry<SoundType> SOUNDS = new ConstRegistry<SoundType>(SoundType.class);
    private static final ConstRegistry<Material> MATERIALS = new ConstRegistry<Material>(Material.class);
    private static final ConstRegistry<CreativeTabs> TABS = new ConstRegistry<CreativeTabs>(CreativeTabs.class);
    private BlockInfo self$ = this;
    @Default(value="")
    private String name = "";
    @Default(value="")
    private String type = "";
    @Default(value="")
    private String tab = "";
    @Default(value="")
    private String material = "";
    @Default(value="")
    private String defaultState = "";
    @Default(value="")
    private String sound = "";
    @Default(value="")
    private String tool = "";
    @Default(value="0")
    private int toolLevel = 0;
    @Default(value="1.5")
    private float hardness = 1.5f;
    @Default(value="10")
    private float resistance = 10.0f;
    @Default(value="0")
    private int lightLevel = 0;
    @Default(value="0")
    private int lightOpacity = 0;
    @Default(value="false")
    private boolean useNeighborBrightness = false;
    @Default(value="false")
    private boolean canSustainPlant = false;
    private List<String> variants = new LinkedList<String>();
    private Map<String, String> meta = new LinkedHashMap<String, String>();

    public void apply(ModBlock modBlock) {
        Block block = modBlock.getBlock();
        block.setRegistryName("conquest", this.name);
        block.func_149663_c(this.getName());
        block.func_149647_a(this.getTab());
        block.func_149752_b(this.getResistance());
        block.func_149711_c(this.getHardness());
        block.func_149715_a((float)this.getLightLevel());
        block.func_149713_g(this.getLightOpacity());
        if (!this.tool.isEmpty()) {
            block.setHarvestLevel(this.getTool(), this.getToolLevel());
        }
    }

    public ModBlock newInstance() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Preconditions.checkState((!this.type.isEmpty() ? 1 : 0) != 0);
        Constructor<? extends ModBlock> constructor = BlockFactory.getConstructor(this.type);
        ModBlock modBlock = constructor.newInstance(this);
        this.apply(modBlock);
        return modBlock;
    }

    public Material getMaterial() {
        return MATERIALS.getValue(this.material, Material.field_151579_a);
    }

    public SoundType getSound() {
        return SOUNDS.getValue(this.sound, SoundType.field_185851_d);
    }

    public IBlockState getDefaultState(Block block) {
        return StateMatcher.matchState(block, this.defaultState);
    }

    public CreativeTabs getTab() {
        return TABS.getValue(this.tab, CreativeTabs.field_78027_g);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getTool() {
        return this.tool;
    }

    public int getToolLevel() {
        return this.toolLevel;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public int getLightLevel() {
        return this.lightLevel;
    }

    public int getLightOpacity() {
        return this.lightOpacity;
    }

    public boolean useNeighborBrightness() {
        return this.useNeighborBrightness;
    }

    public boolean canSustainPlant() {
        return this.canSustainPlant;
    }

    public List<String> getVariants() {
        return this.variants;
    }

    public String getMetaValue(String key) {
        String value = this.meta.get(key);
        if (value == null) {
            throw new MissingBlockMetaException(this.name, key);
        }
        return value;
    }

    public static BlockInfo read(InputStream inputStream) throws Exception {
        return MAPPER.read(inputStream);
    }

    public static void write(BlockInfo info, Writer writer) throws Exception {
        MAPPER.write(info, writer);
    }

    public static BlockInfo fromBlock(ModBlock modBlock) {
        Block block = modBlock.getBlock();
        BlockInfo blockInfo = new BlockInfo();
        blockInfo.name = block.getRegistryName().func_110623_a();
        blockInfo.type = block.getClass().getSimpleName();
        blockInfo.tab = TABS.getName(block.func_149708_J());
        blockInfo.material = MATERIALS.getName(block.func_176194_O().func_177621_b().func_185904_a());
        blockInfo.defaultState = block.func_176223_P().toString();
        blockInfo.sound = SOUNDS.getName(block.func_185467_w());
        blockInfo.tool = block.getHarvestTool(block.func_176223_P());
        blockInfo.toolLevel = block.getHarvestLevel(block.func_176223_P());
        blockInfo.lightLevel = FieldUtil.get(block, "lightValue", Integer.class, blockInfo.lightLevel);
        blockInfo.lightOpacity = FieldUtil.get(block, "lightOpacity", Integer.class, blockInfo.lightLevel);
        blockInfo.canSustainPlant = FieldUtil.get(block, "canSustainPlant", Boolean.class, blockInfo.useNeighborBrightness);
        blockInfo.useNeighborBrightness = FieldUtil.get(block, "useNeighborBrightness", Boolean.class, blockInfo.useNeighborBrightness);
        blockInfo.variants.addAll(modBlock.getVariants());
        IBlockState model = FieldUtil.get(block, "modelState", IBlockState.class, null);
        if (model != null) {
            blockInfo.meta.put("model", model.toString());
        }
        return blockInfo;
    }
}

