/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.init.block;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;

public class ConstRegistry<T> {
    private final Map<String, T> values;
    private final Map<T, String> names;

    ConstRegistry(Class<T> type) {
        ImmutableMap.Builder values = ImmutableMap.builder();
        ImmutableMap.Builder names = ImmutableMap.builder();
        HashSet<T> visited = new HashSet<T>();
        for (Field field : type.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getType() != type) continue;
            try {
                T t = type.cast(field.get(null));
                if (!visited.add(t)) continue;
                names.put(t, (Object)field.getName().toUpperCase());
                values.put((Object)field.getName().toUpperCase(), t);
                values.put((Object)field.getName().toLowerCase(), t);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.values = values.build();
        this.names = names.build();
    }

    public T getValue(String name, T def) {
        return this.values.getOrDefault(name, def);
    }

    public String getName(T val) {
        return this.names.getOrDefault(val, "");
    }
}

