/*
 * Decompiled with CFR 0.152.
 */
package com.conquestreforged.init.block;

import com.conquestreforged.ConquestReforged;
import com.conquestreforged.common.ModBlock;
import com.conquestreforged.common.block.BedBlock;
import com.conquestreforged.common.block.DamageLayerBlock;
import com.conquestreforged.common.block.DoorBlock;
import com.conquestreforged.common.block.LilypadBlock;
import com.conquestreforged.common.blockmeta.BlockLayerMeta;
import com.conquestreforged.common.blockmeta.IMetaBlock;
import com.conquestreforged.common.item.BedItem;
import com.conquestreforged.common.item.DoorItem;
import com.conquestreforged.common.item.ItemBlockMeta;
import com.conquestreforged.common.item.ItemLayerMeta;
import com.conquestreforged.common.item.LilyPadItem;
import com.conquestreforged.common.item.SnowItem;
import com.conquestreforged.common.util.AssetPack;
import com.conquestreforged.init.block.BlockInfo;
import com.conquestreforged.init.block.BlockRegistrationData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks2 {
    private static List<BlockRegistrationData> registry = new LinkedList<BlockRegistrationData>();
    private static final Function<InputStream, BlockInfo> BLOCK_MAPPER = inputStream -> {
        try {
            return BlockInfo.read(inputStream);
        }
        catch (Exception e) {
            return null;
        }
    };

    public static void dispose() {
        registry.clear();
        registry = Collections.emptyList();
    }

    public static void preLoadBlocks() {
        String domain = "conquest";
        ModContainer container = FMLCommonHandler.instance().findContainerFor((Object)ConquestReforged.getInstance());
        try (AssetPack pack = new AssetPack(container.getSource());){
            List index;
            try (InputStream inputStream = pack.getBlockList(domain);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                index = reader.lines().filter(s -> !s.isEmpty()).collect(Collectors.toList());
            }
            String path = String.join((CharSequence)"assets/%s/blocks/.+?\\.conf", domain);
            List<BlockInfo> list = pack.loadAll(Pattern.compile(path), BLOCK_MAPPER);
            HashMap<String, BlockRegistrationData> data = new HashMap<String, BlockRegistrationData>(list.size());
            for (BlockInfo info : list) {
                ModBlock modBlock = info.newInstance();
                ItemBlock itemBlock = ModBlocks2.getItem(modBlock.getBlock());
                BlockRegistrationData blockData = new BlockRegistrationData(info, modBlock, itemBlock);
                data.put(domain + ":" + info.getName(), blockData);
            }
            for (String id : index) {
                BlockRegistrationData block = (BlockRegistrationData)data.get(id);
                if (block == null) {
                    return;
                }
                registry.add(block);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (BlockRegistrationData data : registry) {
            event.getRegistry().register((IForgeRegistryEntry)data.block.getBlock());
        }
    }

    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (BlockRegistrationData item : registry) {
            event.getRegistry().register((IForgeRegistryEntry)item.item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        for (BlockRegistrationData item : registry) {
            List<String> variants = item.info.getVariants();
            if (variants.isEmpty()) {
                ModBlocks2.registerModel((Item)item.item, 0, item.item.getRegistryName());
                continue;
            }
            int id = 0;
            for (String variant : variants) {
                ModBlocks2.registerModel((Item)item.item, id++, variant);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerModel(Item item, int id, Object variant) {
        if (variant != null) {
            ModelResourceLocation model = new ModelResourceLocation(variant.toString(), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)id, (ModelResourceLocation)model);
        }
    }

    private static ItemBlock getItem(Block block) {
        Class<?> type = block.getClass();
        if (type == BedBlock.class) {
            return new BedItem(block);
        }
        if (type == DoorBlock.class) {
            return new DoorItem(block);
        }
        if (type == BlockLayerMeta.class) {
            return new ItemLayerMeta(block);
        }
        if (type == LilypadBlock.class) {
            return new LilyPadItem(block);
        }
        if (type == DamageLayerBlock.class) {
            return new SnowItem(block);
        }
        if (IMetaBlock.class.isInstance(block)) {
            return new ItemBlockMeta(block);
        }
        return new ItemBlock(block);
    }

    public static void generate() {
        ExecutorService service = Executors.newCachedThreadPool();
        File dir = new File("blocks").getAbsoluteFile();
        LinkedList<String> registrationOrder = new LinkedList<String>();
        dir.mkdirs();
        for (ModBlock modBlock : ModBlock.REGISTRAR) {
            ResourceLocation location = modBlock.getBlock().getRegistryName();
            if (location == null) continue;
            registrationOrder.add(location.toString());
            BlockInfo blockInfo = BlockInfo.fromBlock(modBlock);
            File parent = new File(dir, blockInfo.getType());
            service.submit(() -> {
                if (parent.exists() || parent.mkdirs()) {
                    File file = new File(parent, location.func_110623_a() + ".conf");
                    try (FileWriter writer = new FileWriter(file);){
                        BlockInfo.write(blockInfo, writer);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        File blocks = new File(dir, "_registry.index");
        try (FileWriter writer = new FileWriter(blocks);){
            blocks.getParentFile().mkdirs();
            Iterator iterator = registrationOrder.iterator();
            while (iterator.hasNext()) {
                writer.write((String)iterator.next());
                if (!iterator.hasNext()) continue;
                writer.write(10);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        service.shutdown();
    }
}

