/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.color;

import java.awt.Color;
import me.dags.blockpalette.color.ColorF;

public enum ColorConst {
    BLUE(Color.BLUE, "blue"),
    CYAN(Color.CYAN, "cyan"),
    GRAY(Color.DARK_GRAY, "gray"),
    GREEN(Color.GREEN, "green"),
    MAGENTA(Color.MAGENTA, "magenta"),
    ORANGE(Color.ORANGE, "orange"),
    PINK(Color.PINK, "pink"),
    RED(Color.RED, "red"),
    WHITE(Color.WHITE, "white"),
    YELLOW(Color.YELLOW, "yellow");

    private final ColorF color;
    private final String name;

    private ColorConst(Color color, String name) {
        this.color = new ColorF(color);
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static ColorConst nearest(ColorF color) {
        ColorConst[] values = ColorConst.values();
        ColorConst result = values[0];
        double min = Double.MAX_VALUE;
        for (int i = 1; i < values.length; ++i) {
            double dist2;
            ColorConst c = values[i];
            if (c == GRAY || !((dist2 = ColorConst.distanceSq(color, c.color)) < min)) continue;
            min = dist2;
            result = c;
        }
        return result;
    }

    private static double distanceSq(ColorF c1, ColorF c2) {
        float dr = c1.red - c2.red;
        float dg = c1.green - c2.green;
        float db = c1.blue - c2.blue;
        return dr * dr * 0.2989f + dg * dg * 0.587f + db * db * 0.114f;
    }
}

