/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.dags.blockpalette.color.Texture;

public class ColorHue {
    private final Comparator<Texture> comparator;
    private final List<Texture> textures = new ArrayList<Texture>();
    private boolean isDirty = true;

    public ColorHue(Comparator<Texture> comparator) {
        this.comparator = comparator;
    }

    public List<Texture> getTextures() {
        if (this.isDirty) {
            this.isDirty = false;
            Collections.sort(this.textures, this.comparator);
        }
        return this.textures;
    }

    public int size() {
        return this.textures.size();
    }

    public boolean isEmpty() {
        return this.textures.isEmpty();
    }

    public int indexOf(Texture texture) {
        return this.textures.indexOf(texture);
    }

    public void clear() {
        this.isDirty = true;
        this.textures.clear();
    }

    public void addTexture(Texture texture) {
        this.textures.add(texture);
        this.isDirty = true;
    }

    public void matchSaturation(Collection<Texture> results, float strength, float tolerance) {
        List<Texture> textures = this.getTextures();
        if (textures.isEmpty()) {
            return;
        }
        for (Texture texture : textures) {
            if (!(Math.abs(texture.strength - strength) <= tolerance)) continue;
            results.add(texture);
        }
    }

    public void matchLuminance(Collection<Texture> results, float brightness, float tolerance) {
        List<Texture> textures = this.getTextures();
        if (textures.isEmpty()) {
            return;
        }
        for (Texture texture : textures) {
            if (!(Math.abs(texture.brightness - brightness) <= tolerance)) continue;
            results.add(texture);
        }
    }
}

