/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import me.dags.blockpalette.color.ColorHue;
import me.dags.blockpalette.color.Texture;

public class ColorWheel {
    private static final int MAX_OFFSET = 60;
    private static final Comparator<Texture> SORT_GRAY = ColorWheel.sortGray();
    private static final Comparator<Texture> SORT_COLOR = ColorWheel.sortColor();
    private final int mod;
    private final ColorHue[] hues;
    private final ColorHue grays = new ColorHue(SORT_GRAY);
    private final Map<String, Texture> textureMap = new HashMap<String, Texture>();
    private int angle = 30;
    private float leniency = 0.95f;
    private float grayPoint = 0.15f;
    private float alphaPoint = 0.5f;

    public ColorWheel() {
        this(24);
    }

    public ColorWheel(int colorGroups) {
        this.hues = new ColorHue[colorGroups];
        this.mod = 359 / (colorGroups - 1);
        for (int i = 0; i < this.hues.length; ++i) {
            this.hues[i] = new ColorHue(SORT_COLOR);
        }
    }

    public List<Texture> getGrays() {
        return this.grays.getTextures();
    }

    public boolean hasTexture(String name) {
        return this.textureMap.containsKey(name);
    }

    public Texture getTexture(String name) {
        Texture texture = this.textureMap.get(name);
        return texture != null ? texture : Texture.EMPTY;
    }

    public void setAngle(int angle) {
        this.angle = Math.min(120, Math.max(0, angle));
    }

    public void setLeniency(float leniency) {
        this.leniency = Math.min(1.0f, Math.max(0.0f, leniency));
    }

    public void setGrayPoint(float grayPoint) {
        this.grayPoint = Math.min(1.0f, Math.max(0.0f, grayPoint));
    }

    public void setAlphaPoint(float alphaPoint) {
        this.alphaPoint = Math.min(1.0f, Math.max(0.0f, alphaPoint));
    }

    public void refresh() {
        this.getGrays().clear();
        for (ColorHue hue : this.hues) {
            hue.clear();
        }
        for (Texture texture : this.textureMap.values()) {
            this.addTexture(texture);
        }
    }

    public void addTexture(Texture texture) {
        if (!texture.isPresent()) {
            return;
        }
        this.textureMap.put(texture.name, texture);
        if (texture.alpha >= this.alphaPoint) {
            if (this.isGray(texture)) {
                this.grays.addTexture(texture);
            } else {
                this.getHue(texture).addTexture(texture);
            }
        }
    }

    public ColorHue getHue(Texture texture) {
        return this.getHue(ColorWheel.clampHue(texture.hue));
    }

    public ColorHue getHue(int hue) {
        int modified = hue / this.mod;
        int max = this.hues.length - 1;
        int index = Math.min(max, Math.max(0, modified));
        return this.hues[index];
    }

    public boolean isGray(Texture texture) {
        return texture.saturation <= this.grayPoint;
    }

    public List<Texture> getAdjacent(Texture texture, int size) {
        if (!texture.isPresent()) {
            return Collections.emptyList();
        }
        if (this.isGray(texture)) {
            return this.getAdjacentGrays(texture, size);
        }
        return this.getAdjacentHues(texture, size);
    }

    public List<Texture> getComplimentary(Texture texture, int size) {
        if (!texture.isPresent()) {
            return Collections.emptyList();
        }
        if (this.isGray(texture)) {
            float opposite = Math.min(1.0f, Math.max(0.0f, 1.0f - texture.brightness));
            List<Texture> l1 = this.matchGray(texture.brightness, size);
            List<Texture> l2 = this.matchGray(opposite, size);
            l1.addAll(l2);
            return l1;
        }
        int opposite = ColorWheel.clampHue(texture.hue - 180);
        List<Texture> l1 = this.matchColor(texture.hue, texture.strength, size);
        List<Texture> l2 = this.matchColor(opposite, texture.strength, size);
        l1.addAll(l2);
        return l1;
    }

    public List<Texture> getTriad(Texture texture, int groupSize) {
        if (!texture.isPresent()) {
            return Collections.emptyList();
        }
        if (this.isGray(texture)) {
            return this.getGrayTriad(texture, groupSize);
        }
        return this.getHueTriad(texture, groupSize);
    }

    public List<Texture> getTetrad(Texture texture, int groupSize) {
        if (!texture.isPresent()) {
            return Collections.emptyList();
        }
        if (this.isGray(texture)) {
            return this.getGrayTetrad(texture, groupSize);
        }
        return this.getHueTetrad(texture, groupSize);
    }

    public List<Texture> getRainbow(Texture texture, int groupSize) {
        if (!texture.isPresent()) {
            return Collections.emptyList();
        }
        if (this.isGray(texture)) {
            return Collections.emptyList();
        }
        ArrayList<Texture> textures = new ArrayList<Texture>();
        int distance = 45;
        for (int i = 0; i < 12; ++i) {
            int hue = texture.hue + i * distance;
            textures.addAll(this.matchColor(hue, texture.strength, groupSize));
        }
        return textures;
    }

    private List<Texture> getAdjacentHues(Texture texture, int groupSize) {
        int h1 = texture.hue;
        int h2 = ColorWheel.clampHue(texture.hue - this.angle);
        int h3 = ColorWheel.clampHue(texture.hue + this.angle);
        List<Texture> l1 = this.matchColor(h1, texture.strength, groupSize);
        List<Texture> l2 = this.matchColor(h2, texture.strength, groupSize);
        List<Texture> l3 = this.matchColor(h3, texture.strength, groupSize);
        int min = Math.min(l1.size(), Math.min(l2.size(), l3.size()));
        if (min != groupSize) {
            ColorWheel.trimList(l1, min);
            ColorWheel.trimList(l2, min);
            ColorWheel.trimList(l3, min);
        }
        l1.addAll(l2);
        l1.addAll(l3);
        return l1;
    }

    private List<Texture> getHueTriad(Texture texture, int groupSize) {
        int h1 = texture.hue;
        int h2 = ColorWheel.clampHue(texture.hue - 180 - this.angle);
        int h3 = ColorWheel.clampHue(texture.hue - 180 + this.angle);
        List<Texture> l1 = this.matchColor(h1, texture.strength, groupSize);
        List<Texture> l2 = this.matchColor(h2, texture.strength, groupSize);
        List<Texture> l3 = this.matchColor(h3, texture.strength, groupSize);
        int min = Math.min(l1.size(), Math.min(l2.size(), l3.size()));
        if (min != groupSize) {
            ColorWheel.trimList(l1, min);
            ColorWheel.trimList(l2, min);
            ColorWheel.trimList(l3, min);
        }
        l1.addAll(l2);
        l1.addAll(l3);
        return l1;
    }

    private List<Texture> getHueTetrad(Texture texture, int groupSize) {
        int h1 = ColorWheel.clampHue(texture.hue);
        int h2 = ColorWheel.clampHue(texture.hue + this.angle);
        int h3 = ColorWheel.clampHue(texture.hue + 180);
        int h4 = ColorWheel.clampHue(texture.hue + 180 + this.angle);
        List<Texture> l1 = this.matchColor(h1, texture.strength, groupSize);
        List<Texture> l2 = this.matchColor(h2, texture.strength, groupSize);
        List<Texture> l3 = this.matchColor(h3, texture.strength, groupSize);
        List<Texture> l4 = this.matchColor(h4, texture.strength, groupSize);
        int min = Math.min(l1.size(), Math.min(l2.size(), Math.min(l3.size(), l4.size())));
        if (min != groupSize) {
            ColorWheel.trimList(l1, min);
            ColorWheel.trimList(l2, min);
            ColorWheel.trimList(l3, min);
            ColorWheel.trimList(l4, min);
        }
        l1.addAll(l2);
        l1.addAll(l3);
        l1.addAll(l4);
        return l1;
    }

    private List<Texture> getAdjacentGrays(Texture texture, int groupSize) {
        return Collections.emptyList();
    }

    private List<Texture> getGrayTriad(Texture texture, int groupSize) {
        float p1;
        float range;
        if (texture.brightness < 0.0f) {
            range = 1.0f - texture.brightness;
            p1 = texture.brightness;
        } else if (texture.brightness > 0.0f) {
            range = texture.brightness;
            p1 = 0.0f;
        } else {
            range = 2.0f * Math.min(texture.brightness, 1.0f - texture.brightness);
            p1 = texture.brightness - range / 2.0f;
        }
        float p2 = p1 + range / 2.0f;
        float p3 = p1 + range;
        List<Texture> l1 = this.matchGray(p1, groupSize);
        List<Texture> l2 = this.matchGray(p2, groupSize);
        List<Texture> l3 = this.matchGray(p3, groupSize);
        int min = Math.min(l1.size(), Math.min(l2.size(), l3.size()));
        if (min != groupSize) {
            ColorWheel.trimList(l1, min);
            ColorWheel.trimList(l2, min);
            ColorWheel.trimList(l3, min);
        }
        l1.addAll(l2);
        l1.addAll(l3);
        return l1;
    }

    private List<Texture> getGrayTetrad(Texture texture, int groupSize) {
        float p1;
        float range;
        float l = texture.brightness;
        if (l < 0.25f) {
            range = 1.0f - l;
            p1 = l;
        } else if (l < 0.5f) {
            range = (1.0f - l) / 2.0f * 3.0f;
            p1 = 1.0f - range;
        } else if (l < 0.75f) {
            range = l / 2.0f * 3.0f;
            p1 = 0.0f;
        } else {
            range = l;
            p1 = 0.0f;
        }
        float step = range / 3.0f;
        float p2 = p1 + step;
        float p3 = p1 + 2.0f * step;
        float p4 = p1 + range;
        List<Texture> l1 = this.matchGray(p1, groupSize);
        List<Texture> l2 = this.matchGray(p2, groupSize);
        List<Texture> l3 = this.matchGray(p3, groupSize);
        List<Texture> l4 = this.matchGray(p4, groupSize);
        int min = Math.min(l1.size(), Math.min(l2.size(), Math.min(l3.size(), l4.size())));
        if (min != groupSize) {
            ColorWheel.trimList(l1, min);
            ColorWheel.trimList(l2, min);
            ColorWheel.trimList(l3, min);
            ColorWheel.trimList(l4, min);
        }
        l1.addAll(l2);
        l1.addAll(l3);
        l1.addAll(l4);
        return l1;
    }

    private List<Texture> matchColor(int hue, float strength, int size) {
        LinkedHashSet<Texture> results = new LinkedHashSet<Texture>();
        for (int offset = 0; offset < 60 && results.size() < size; ++offset) {
            if (offset == 0) {
                this.getHue(ColorWheel.clampHue(hue)).matchSaturation(results, strength, this.leniency);
                continue;
            }
            this.getHue(ColorWheel.clampHue(hue - offset)).matchSaturation(results, strength, this.leniency);
            this.getHue(ColorWheel.clampHue(hue + offset)).matchSaturation(results, strength, this.leniency);
        }
        ArrayList<Texture> list = new ArrayList<Texture>(results);
        Collections.shuffle(list);
        ColorWheel.trimList(list, size);
        Collections.sort(list, SORT_COLOR);
        return list;
    }

    private List<Texture> matchGray(float brightness, int size) {
        LinkedHashSet<Texture> results = new LinkedHashSet<Texture>();
        this.grays.matchLuminance(results, brightness, this.leniency / 2.0f);
        ArrayList<Texture> list = new ArrayList<Texture>(results);
        Collections.shuffle(list);
        ColorWheel.trimList(list, size);
        Collections.sort(list, SORT_GRAY);
        return list;
    }

    private static void trimList(List<?> list, int size) {
        while (list.size() > size) {
            list.remove(list.size() - 1);
        }
    }

    private static int clampHue(float input) {
        int hue = Math.round(input);
        if (hue < 0) {
            hue = 360 + hue % 360;
        } else if (hue > 360) {
            hue %= 360;
        }
        return Math.min(359, Math.max(0, hue));
    }

    private static Comparator<Texture> sortGray() {
        return new Comparator<Texture>(){

            @Override
            public int compare(Texture t1, Texture t2) {
                return Float.compare(t2.luminosity, t1.luminosity);
            }
        };
    }

    private static Comparator<Texture> sortColor() {
        return new Comparator<Texture>(){

            @Override
            public int compare(Texture t1, Texture t2) {
                if (Math.abs(t2.strength - t1.strength) < 0.05f) {
                    return Float.compare(t2.luminosity, t1.luminosity);
                }
                if (Math.abs(t2.saturation - t1.saturation) < 0.1f) {
                    return Float.compare(t2.brightness, t1.brightness);
                }
                return Float.compare(t2.strength, t1.strength);
            }
        };
    }
}

