/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.gui;

import me.dags.blockpalette.gui.SlotBounds;
import me.dags.blockpalette.palette.PaletteItem;
import me.dags.blockpalette.util.Config;
import me.dags.blockpalette.util.Render;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Slot {
    private static final ResourceLocation SLOT = new ResourceLocation("blockpalette", "textures/gui/slot.png");
    private final PaletteItem item;
    private boolean hovered = false;
    private boolean selected = false;
    private float scale = 1.0f;
    private int xPos = 0;
    private int yPos = 0;
    private int invertColor = 0;
    private int highlightColor = 0;
    private float highlightSize = 1.1f;
    private SlotBounds bounds = new SlotBounds();

    public Slot(PaletteItem item) {
        this.item = item;
    }

    public int xPos() {
        return this.xPos;
    }

    public int yPos() {
        return this.yPos;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isEmpty() {
        return this.item.isEmpty();
    }

    public PaletteItem getItem() {
        return this.item;
    }

    public ItemStack getStack() {
        return this.item.getItemStack();
    }

    public boolean mouseOver(int x, int y) {
        return x >= this.xPos - 11 && x <= this.xPos + 11 && y >= this.yPos - 11 && y <= this.yPos + 11;
    }

    public void setBounds(SlotBounds bounds) {
        this.bounds = bounds;
    }

    public void setHighlight(int color, int invert, float size) {
        this.highlightColor = color;
        this.highlightSize = size;
        this.invertColor = invert;
    }

    public void setPosition(int x, int y) {
        this.xPos = x;
        this.yPos = y;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public void setHovered(boolean hovered) {
        this.hovered = hovered;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void draw() {
        if (!this.isEmpty()) {
            Render.beginSlot(this.xPos, this.yPos, this.scale);
            Render.drawTexture(SLOT, -11, -11, 22, 22, 0.0f, 0.0f, 22.0f, 22.0f);
            if (this.hovered || this.selected) {
                int color = this.selected ? this.invertColor : this.highlightColor;
                Render.drawHighlightedItemStack(this.getStack(), 0, 0, this.highlightSize, color);
            } else {
                Render.drawItemStack(this.getStack(), -8, -8);
            }
            Render.endSlot();
        }
    }

    public void drawBounds() {
        if (!this.isEmpty() && !Config.match_textures) {
            this.bounds.draw(this.item.getColor().red, this.item.getColor().green, this.item.getColor().blue, 1.0f);
        }
    }
}

