/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.gui;

import me.dags.blockpalette.util.Value;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Tooltip {
    private final FontRenderer fontRenderer;
    private final Provider tooltip;
    private final int width;
    private final int pad = 5;
    private final int offsetX;
    private final GuiButton button;

    private Tooltip(GuiButton button, Provider tooltip, int width) {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.pad = 5;
        this.button = button;
        this.tooltip = tooltip;
        this.width = width;
        this.offsetX = width / 2;
    }

    public void draw(int x, int y, float ticks) {
        if (this.button.func_146115_a()) {
            String message = I18n.func_135052_a((String)this.tooltip.getUnlocalized(), (Object[])new Object[0]);
            int stringWidth = this.fontRenderer.func_78256_a(message);
            int lines = 2 + stringWidth / this.width;
            int height = this.fontRenderer.field_78288_b * lines;
            int offsetY = height + 5 + 5;
            int left = x - this.offsetX - 5;
            int top = y - offsetY - 5;
            int right = left + this.width + 5 + 5;
            int bottom = top + height + 5 + 5;
            Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-587202560);
            int textLeft = left + 5;
            int textTop = top + 5;
            this.fontRenderer.func_78279_b(message, textLeft, textTop, this.width, 0xFFFFFF);
        }
    }

    public static Tooltip of(GuiButton button, Provider provider) {
        return new Tooltip(button, provider, 150);
    }

    static class PointerTip<T extends Provider>
    implements Provider {
        private final Value<T> option;

        PointerTip(Value<T> option) {
            this.option = option;
        }

        @Override
        public String getUnlocalized() {
            return ((Provider)this.option.get()).getUnlocalized();
        }
    }

    static class Simple
    implements Provider {
        private final String tooltip;

        Simple(String tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public String getUnlocalized() {
            return this.tooltip;
        }
    }

    public static interface Provider {
        public String getUnlocalized();
    }
}

