/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.palette;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.dags.blockpalette.color.ColorF;
import me.dags.blockpalette.color.ColorWheel;
import me.dags.blockpalette.color.Texture;
import me.dags.blockpalette.palette.Palette;
import me.dags.blockpalette.palette.PaletteItem;
import me.dags.blockpalette.util.Config;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PaletteRegistry {
    private static final IBlockState EMPTY_STATE = Blocks.field_150350_a.func_176223_P();
    private final Map<String, List<Mapping>> textureVariants = new HashMap<String, List<Mapping>>();
    private final Map<String, Mapping> mappings = new HashMap<String, Mapping>();
    private final ColorWheel colorWheel = new ColorWheel();
    private final Set<Block> blacklist = ImmutableSet.of((Object)Blocks.field_150483_bI, (Object)Blocks.field_185777_dd, (Object)Blocks.field_185776_dc, (Object)Blocks.field_185779_df, (Object)Blocks.field_189881_dj);

    public ColorF getColor(ItemStack stack, ColorF def) {
        Texture texture = this.getTextureForStack(stack);
        return texture.isPresent() ? texture.getColor() : def;
    }

    public void buildPalettes() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        BlockPos pos = player.func_180425_c().func_177977_b();
        World world = player.field_70170_p;
        for (Block block : Block.field_149771_c) {
            if (this.blacklist.contains(block)) continue;
            NonNullList stacks = NonNullList.func_191196_a();
            block.func_149666_a(CreativeTabs.field_78027_g, stacks);
            for (ItemStack stack : stacks) {
                if (stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a) continue;
                try {
                    IBlockState state = block.getStateForPlacement(world, pos, EnumFacing.UP, 0.5f, 0.5f, 0.5f, stack.func_77960_j(), (EntityLivingBase)player, EnumHand.MAIN_HAND);
                    this.register(stack, state);
                }
                catch (Throwable t) {
                    System.err.printf("Unable to register Item: %s (%s) for Block: %s\n", stack.func_77973_b(), stack.func_77960_j(), block.getRegistryName());
                }
            }
        }
    }

    public Palette getPalette(ItemStack itemStack) {
        if (itemStack == null || itemStack == ItemStack.field_190927_a || Block.func_149634_a((Item)itemStack.func_77973_b()) == Blocks.field_150350_a) {
            return Palette.EMPTY;
        }
        if (Config.match_textures) {
            return this.getVariantPalette(itemStack);
        }
        itemStack = itemStack.func_77946_l();
        itemStack.func_190920_e(1);
        this.colorWheel.setAngle(Config.angle);
        this.colorWheel.setLeniency(Config.leniency);
        this.colorWheel.setGrayPoint(Config.gray_point);
        this.colorWheel.setAlphaPoint(Config.alpha_point);
        this.colorWheel.refresh();
        switch (Config.color_mode) {
            case COMPLIMENTARY: {
                return this.getComplimentaryPalette(itemStack);
            }
            case TRIAD: {
                return this.getTriadPalette(itemStack);
            }
            case TETRAD: {
                return this.getTetradPalette(itemStack);
            }
            case RAINBOW: {
                return this.getRainbowPalette(itemStack);
            }
        }
        return this.getAdjacentPalette(itemStack);
    }

    private Palette getColorPalette(ItemStack stack, List<PaletteItem> list) {
        Texture texture = this.getTextureForStack(stack);
        ColorF colorF = texture != null ? texture.getColor() : ColorF.EMPTY;
        return Palette.colorPalette(PaletteItem.of(stack, colorF), list);
    }

    public Palette getVariantPalette(ItemStack stack) {
        return this.getVariantPalette(stack, Sets.newHashSet((Object[])new Mapping[]{new Mapping(stack)}));
    }

    public Palette getVariantPalette(ItemStack stack, Set<Mapping> filter) {
        List<Mapping> variants = this.getMatchingTexture(stack);
        List<PaletteItem> entries = this.statesToVariants(variants, filter);
        return Palette.texturePalette(PaletteItem.of(stack), entries);
    }

    public Palette getAdjacentPalette(ItemStack stack) {
        return this.getAdjacentPalette(stack, Sets.newHashSet((Object[])new Mapping[]{new Mapping(stack)}));
    }

    public Palette getAdjacentPalette(ItemStack stack, Set<Mapping> filter) {
        Texture texture = this.getTextureForStack(stack);
        List<Texture> adjacent = this.colorWheel.getAdjacent(texture, Config.group_size);
        List<PaletteItem> entries = this.texturesToVariants(adjacent, filter);
        return this.getColorPalette(stack, entries);
    }

    public Palette getComplimentaryPalette(ItemStack stack) {
        return this.getComplimentaryPalette(stack, Sets.newHashSet((Object[])new Mapping[]{new Mapping(stack)}));
    }

    public Palette getComplimentaryPalette(ItemStack stack, Set<Mapping> filter) {
        Texture texture = this.getTextureForStack(stack);
        List<Texture> complimentary = this.colorWheel.getComplimentary(texture, Config.group_size);
        List<PaletteItem> entries = this.texturesToVariants(complimentary, filter);
        return this.getColorPalette(stack, entries);
    }

    public Palette getTriadPalette(ItemStack stack) {
        return this.getTriadPalette(stack, Sets.newHashSet((Object[])new Mapping[]{new Mapping(stack)}));
    }

    public Palette getTriadPalette(ItemStack stack, Set<Mapping> filter) {
        Texture texture = this.getTextureForStack(stack);
        List<Texture> triad = this.colorWheel.getTriad(texture, Config.group_size);
        List<PaletteItem> entries = this.texturesToVariants(triad, filter);
        return this.getColorPalette(stack, entries);
    }

    public Palette getTetradPalette(ItemStack stack) {
        return this.getTetradPalette(stack, Sets.newHashSet((Object[])new Mapping[]{new Mapping(stack)}));
    }

    public Palette getTetradPalette(ItemStack stack, Set<Mapping> filter) {
        Texture texture = this.getTextureForStack(stack);
        List<Texture> tetrad = this.colorWheel.getTetrad(texture, Config.group_size);
        List<PaletteItem> entries = this.texturesToVariants(tetrad, filter);
        return this.getColorPalette(stack, entries);
    }

    public Palette getRainbowPalette(ItemStack stack) {
        return this.getRainbowPalette(stack, Sets.newHashSet((Object[])new Mapping[]{new Mapping(stack)}));
    }

    public Palette getRainbowPalette(ItemStack stack, Set<Mapping> filter) {
        Texture texture = this.getTextureForStack(stack);
        List<Texture> rainbow = this.colorWheel.getRainbow(texture, Config.group_size);
        List<PaletteItem> entries = this.texturesToVariants(rainbow, filter);
        return this.getColorPalette(stack, entries);
    }

    private List<Mapping> getMatchingTexture(ItemStack itemStack) {
        String texture = PaletteRegistry.getItemModel(itemStack).func_177554_e().func_94215_i();
        List<Mapping> states = this.textureVariants.get(texture);
        return states != null ? states : Collections.emptyList();
    }

    private List<PaletteItem> statesToVariants(List<Mapping> variants, Set<Mapping> filter) {
        ArrayList<PaletteItem> results = new ArrayList<PaletteItem>();
        for (Mapping variant : variants) {
            if (!filter.add(variant)) continue;
            ItemStack itemStack = variant.itemStack.func_77946_l();
            results.add(PaletteItem.of(itemStack, ColorF.EMPTY));
        }
        return results;
    }

    private List<PaletteItem> texturesToVariants(List<Texture> textures, Set<Mapping> filter) {
        ArrayList<PaletteItem> results = new ArrayList<PaletteItem>();
        for (Texture texture : textures) {
            Mapping variant = this.mappings.get(texture.name);
            if (variant == EMPTY_STATE || !filter.add(variant)) continue;
            ItemStack itemStack = variant.itemStack.func_77946_l();
            results.add(PaletteItem.of(itemStack, texture.getColor()));
        }
        return results;
    }

    private Texture getTextureForStack(ItemStack itemStack) {
        String icon = PaletteRegistry.getItemModel(itemStack).func_177554_e().func_94215_i();
        return this.colorWheel.getTexture(icon);
    }

    private void register(ItemStack stack, IBlockState state) {
        IBakedModel model = PaletteRegistry.getModel(state);
        if (!PaletteRegistry.isValidModel(model)) {
            PaletteRegistry.writeItemError("Unable to register model for Item: %s, Texture: %s", stack, model);
            return;
        }
        if (!PaletteRegistry.hasParticleTexture(model)) {
            PaletteRegistry.writeItemError("Unable to determine particle texture for Item: %s, Texture: %s", stack, model);
            return;
        }
        String iconName = model.func_177554_e().func_94215_i();
        if (iconName == null) {
            PaletteRegistry.writeItemError("Null particle texture!? Item: %s, Texture: %s", stack, model);
            return;
        }
        Mapping mapping = new Mapping(stack);
        Mapping current = this.mappings.get(iconName);
        if (mapping.overrides(current)) {
            this.mappings.put(iconName, mapping);
        }
        this.textureVariants.computeIfAbsent(iconName, k -> new ArrayList()).add(mapping);
        if (this.colorWheel.hasTexture(iconName)) {
            return;
        }
        Texture texture = PaletteRegistry.fromSprite(model.func_177554_e());
        if (texture != null) {
            this.colorWheel.addTexture(texture);
        }
    }

    private static IBakedModel getModel(IBlockState state) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        return PaletteRegistry.ensure(model, PaletteRegistry.missingModel());
    }

    private static IBakedModel getItemModel(ItemStack itemStack) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(itemStack);
        return PaletteRegistry.ensure(model, PaletteRegistry.missingModel());
    }

    private static IBakedModel ensure(IBakedModel model, IBakedModel missing) {
        if (model != null && model.func_177554_e() != null && model.func_177554_e().func_94215_i() != null) {
            return model;
        }
        return missing;
    }

    private static Texture fromSprite(TextureAtlasSprite sprite) {
        int[][] data;
        if (sprite.func_110970_k() > 0 && (data = sprite.func_147965_a(0)).length > 0) {
            int[] pixels = data[0];
            return new Texture(sprite.func_94215_i(), sprite.func_94211_a(), sprite.func_94216_b(), pixels);
        }
        return null;
    }

    private static boolean isValidModel(@Nullable IBakedModel model) {
        return model != null && model != Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a();
    }

    private static boolean hasParticleTexture(@Nonnull IBakedModel model) {
        TextureAtlasSprite particle = model.func_177554_e();
        return particle != null && !particle.func_94215_i().equals("missinno");
    }

    private static IBakedModel missingModel() {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a();
    }

    private static void writeItemError(String format, ItemStack stack, IBakedModel model) {
        String item = stack == null || stack.func_77973_b() == null || stack.func_77973_b() == Items.field_190931_a ? "null" : String.format("%s (%s)", PaletteRegistry.toString(stack.func_77973_b().getRegistryName()), stack.func_77960_j());
        String modl = model == null || model.func_177554_e() == null ? "null" : String.format("%s (%s)", PaletteRegistry.toString(model.func_177554_e().func_94215_i()), model.getClass());
        System.err.println(String.format(format, item, modl));
    }

    private static String toString(@Nullable Object o) {
        return "" + o;
    }

    private static class Mapping {
        private final ItemStack itemStack;
        private final boolean mainTab;
        private final boolean isFullBlock;
        private final int hashCode;

        private Mapping(ItemStack stack) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            this.itemStack = stack;
            this.hashCode = this.itemStack.func_77973_b().func_77667_c(this.itemStack).hashCode();
            this.mainTab = this.itemStack.func_77973_b().func_77640_w() == CreativeTabs.field_78030_b;
            this.isFullBlock = block != Blocks.field_150350_a && block.func_176223_P().func_185913_b();
        }

        private boolean overrides(Mapping other) {
            return other == null || !other.mainTab && this.mainTab || !other.isFullBlock && this.isFullBlock;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof ItemStack) {
                ItemStack stack = (ItemStack)other;
                return stack.func_77973_b().func_77667_c(stack).hashCode() == this.hashCode();
            }
            return other.hashCode() == this.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

