/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.search;

public class Result<T>
implements Comparable<Result> {
    private static final Result<?> EMPTY = new Result<Object>(null, Integer.MAX_VALUE, 2.147483647E9);
    private final T result;
    private final int rank;
    private final double score;

    public Result(T result, int rank, double score) {
        this.result = result;
        this.rank = rank;
        this.score = score;
    }

    public T getResult() {
        return this.result;
    }

    public int getRank() {
        return this.rank;
    }

    public boolean isPresent() {
        return this != EMPTY;
    }

    @Override
    public int compareTo(Result result) {
        if (this.rank == result.rank) {
            return Double.compare(this.score, result.score);
        }
        return Integer.compare(this.rank, result.rank);
    }

    public String toString() {
        return String.format("%s, rank=%s, score=%s", this.result, this.rank, this.score);
    }

    public static <T> Result<T> empty() {
        return EMPTY;
    }
}

