/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.search;

import com.google.common.collect.ImmutableList;
import java.util.List;

public interface Tag {
    public static final List<Tag> TAGS = ImmutableList.builder().add((Object)Tag.of("slab")).add((Object)Tag.of("stair")).add((Object)Tag.of("wall")).add((Object)Tag.of("fence")).add((Object)Tag.of("gate")).add((Object)Tag.of("carpet")).add((Object)Tag.of("layer")).add((Object)Tag.not("plate", "plate", "chestplate")).add((Object)Tag.of("log")).add((Object)Tag.of("pillar")).add((Object)Tag.of("column")).add((Object)Tag.not("door", "door", "trapdoor")).add((Object)Tag.of("trapdoor")).add((Object)Tag.or("leaves", "leaves", "leaf")).add((Object)Tag.not("bed", "bed", "bedrock")).add((Object)Tag.of("arch")).add((Object)Tag.of("corner")).add((Object)Tag.of("glass")).add((Object)Tag.of("pane")).add((Object)Tag.of("stained")).add((Object)Tag.of("hardened")).add((Object)Tag.of("dye")).add((Object)Tag.of("egg")).add((Object)Tag.of("potion")).add((Object)Tag.of("arrow")).add((Object)Tag.or("armor", "helmet", "chestplate", "leggings", "boots")).add((Object)Tag.of("helmet")).add((Object)Tag.of("chestplate")).add((Object)Tag.of("leggings")).add((Object)Tag.of("boots")).add((Object)Tag.or("food", "apple", "stew", "bread", "pork", "beef", "steak", "mutton", "chicken", "rabbit", "fish", "carrot", "potato", "pumpkin", "melon")).add((Object)Tag.or("tool", "axe", "pick", "shovel", "hoe", "shear", "compass", "clock", "fishing rod")).add((Object)Tag.or("weapon", "sword", "bow", "splash", "arrow")).add((Object)Tag.of("sword")).add((Object)Tag.of("hoe")).add((Object)Tag.of("pickaxe")).add((Object)Tag.not("axe", "axe", "pickaxe")).add((Object)Tag.of("shovel")).build();

    public static Tag of(String name) {
        return () -> name;
    }

    public static Tag and(final String name, final String ... and) {
        return new Tag(){

            @Override
            public String getTag() {
                return name;
            }

            @Override
            public boolean test(String in) {
                for (String s : and) {
                    if (in.contains(s)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static Tag or(final String name, final String ... or) {
        return new Tag(){

            @Override
            public String getTag() {
                return name;
            }

            @Override
            public boolean test(String in) {
                for (String s : or) {
                    if (!in.contains(s)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Tag not(final String name, final String accept, final String reject) {
        return new Tag(){

            @Override
            public String getTag() {
                return name;
            }

            @Override
            public boolean test(String in) {
                return in.contains(accept) && !in.contains(reject);
            }
        };
    }

    public String getTag();

    default public boolean test(String in) {
        return in.contains(this.getTag());
    }
}

