/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.shape;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import me.dags.blockpalette.gui.SlotBounds;
import me.dags.blockpalette.shape.Edge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Polygon {
    private final List<Edge> edges = new ArrayList<Edge>();
    private final int outerPadding;
    private final int innerPadding;
    private final float angleInc;
    private final int edgeCount;
    private final int radius;

    public Polygon(int edges, int radius, int outerPadding, int innerPadding) {
        this.radius = radius;
        this.edgeCount = edges;
        this.angleInc = 360.0f / (float)edges;
        this.outerPadding = outerPadding;
        this.innerPadding = innerPadding;
    }

    public SlotBounds outline() {
        SlotBounds bounds = new SlotBounds().startNew();
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            bounds.add(this.edges.get((int)i).start);
        }
        return bounds;
    }

    public void init(int centerX, int centerY) {
        Point cStart = new Point(centerX + this.radius, centerY);
        Point oStart = new Point(centerX + this.radius + this.outerPadding, centerY);
        Point iStart = new Point(centerX + this.radius - this.innerPadding, centerY);
        for (int i = 0; i <= this.edgeCount; ++i) {
            double angle = this.angleInc * (float)i;
            if (i != 0) {
                Edge edge = new Edge(cStart, oStart, iStart, centerX, centerY, this.radius, this.outerPadding, this.innerPadding, angle, this.angleInc);
                cStart = edge.end;
                oStart = edge.outerEnd;
                iStart = edge.innerEnd;
                this.edges.add(edge);
                continue;
            }
            double rads = Math.toRadians(angle);
            cStart = Edge.toPoint(centerX, centerY, this.radius, rads);
            oStart = Edge.toPoint(centerX, centerY, this.radius + this.outerPadding, rads);
            iStart = Edge.toPoint(centerX, centerY, this.radius - this.innerPadding, rads);
        }
    }

    private Edge getEdge(double angle) {
        for (Edge edge : this.edges) {
            if (!(angle < edge.getAngle())) continue;
            return edge;
        }
        return this.edges.get(0);
    }

    public Point getPosition(float angle) {
        return this.getEdge(angle).getPosition(angle);
    }

    public SlotBounds getBounds(float angle, float halfSpacing) {
        float min = Polygon.clampAngle(angle - halfSpacing);
        float max = Polygon.clampAngle(angle + halfSpacing);
        Edge center = this.getEdge(angle);
        Edge lower = this.getEdge(min);
        Edge upper = this.getEdge(max);
        SlotBounds bounds = new SlotBounds().startNew();
        if (lower != center) {
            bounds.add(lower.getInnerPosition(min));
            bounds.add(center.innerStart);
            bounds.add(center.outerStart);
            bounds.add(lower.getOuterPosition(min));
            if (upper != center) {
                bounds.startNew();
                bounds.add(center.innerStart);
                bounds.add(center.innerEnd);
                bounds.add(center.outerEnd);
                bounds.add(center.outerStart);
                bounds.startNew();
                bounds.add(center.innerEnd);
                bounds.add(upper.getInnerPosition(max));
                bounds.add(upper.getOuterPosition(max));
                bounds.add(center.outerEnd);
            } else {
                bounds.startNew();
                bounds.add(center.innerStart);
                bounds.add(upper.getInnerPosition(max));
                bounds.add(upper.getOuterPosition(max));
                bounds.add(center.outerStart);
            }
        } else if (upper != center) {
            bounds.add(lower.getOuterPosition(min));
            bounds.add(lower.getInnerPosition(min));
            bounds.add(center.innerEnd);
            bounds.add(center.outerEnd);
            bounds.startNew();
            bounds.add(center.innerEnd);
            bounds.add(upper.getInnerPosition(max));
            bounds.add(upper.getOuterPosition(max));
            bounds.add(center.outerEnd);
        } else {
            bounds.add(lower.getOuterPosition(min));
            bounds.add(lower.getInnerPosition(min));
            bounds.add(upper.getInnerPosition(max));
            bounds.add(upper.getOuterPosition(max));
        }
        return bounds;
    }

    private static float clampAngle(float value) {
        return value < 0.0f ? 360.0f + value : (value > 360.0f ? value - 360.0f : value);
    }
}

