/*
 * Decompiled with CFR 0.152.
 */
package me.dags.blockpalette.util;

public class Value<T> {
    private final boolean instant;
    private Listener<T> listener;
    private T reference = null;
    private boolean dirty = false;

    private Value(T value) {
        this.reference = value;
        this.instant = false;
    }

    private Value(T value, boolean instant) {
        this.reference = value;
        this.instant = instant;
    }

    public boolean isPresent() {
        return this.reference != null;
    }

    public T get() {
        return this.reference;
    }

    public void setNullable(T value) {
        this.reference = value;
        this.dirty = true;
        if (this.instant) {
            this.markUpdated();
        }
    }

    public void set(T value) {
        if (this.reference != value && !this.reference.equals(value)) {
            this.reference = value;
            this.dirty = true;
            if (this.instant) {
                this.markUpdated();
            }
        }
    }

    public void markUpdated() {
        if (this.dirty && this.listener != null && this.reference != null) {
            this.listener.onUpdate(this.reference);
        }
        this.dirty = false;
    }

    public void setListener(Listener<T> listener) {
        this.listener = listener;
    }

    public static <T> Value<T> of(T value) {
        return new Value<T>(value);
    }

    public static <T> Value<T> instant(T value) {
        return new Value<T>(value, true);
    }

    public static interface Listener<T> {
        public void onUpdate(T var1);
    }
}

