/*
 * Decompiled with CFR 0.152.
 */
package me.dags.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.dags.config.ListNode;
import me.dags.config.MapNode;
import me.dags.config.Node;
import me.dags.config.ObjectNode;
import me.dags.config.ValueNode;
import me.dags.config.style.Comment;
import me.dags.config.style.Default;
import me.dags.config.style.Order;
import me.dags.config.style.Style;

class ClassMapper {
    private static final Map<Class<?>, Function<String, ?>> PRIMITIVES = new HashMap<Class<?>, Function<String, ?>>(){
        {
            this.put(Boolean.TYPE, Boolean::parseBoolean);
            this.put(Boolean.class, Boolean::parseBoolean);
            this.put(Byte.TYPE, Byte::parseByte);
            this.put(Byte.class, Byte::parseByte);
            this.put(Character.TYPE, Byte::parseByte);
            this.put(Character.class, Byte::parseByte);
            this.put(Double.TYPE, Double::parseDouble);
            this.put(Double.class, Double::parseDouble);
            this.put(Float.TYPE, Float::parseFloat);
            this.put(Float.class, Float::parseFloat);
            this.put(Integer.TYPE, Integer::parseInt);
            this.put(Integer.class, Integer::parseInt);
            this.put(Long.TYPE, Long::parseLong);
            this.put(Long.class, Long::parseLong);
            this.put(Short.TYPE, Short::parseShort);
            this.put(Short.class, Short::parseShort);
            this.put(String.class, s -> s);
        }
    };

    private ClassMapper() {
    }

    static <T> Node<T> getNode(Class<T> type) {
        return ClassMapper.createNode(type);
    }

    private static <T> Node<T> createNode(Class<T> type) {
        if (ClassMapper.isPrimitive(type)) {
            return new ValueNode(null, ClassMapper.getParser(type), null);
        }
        try {
            Field self = type.getDeclaredField("$self");
            if (self != null && self.getType() == type) {
                self.setAccessible(true);
                return ClassMapper.createFieldNode(self);
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return ClassMapper.createObjectNode(type, null);
    }

    private static <T> Node<T> createObjectNode(Class<T> c, Field parent) {
        ObjectNode.Builder<T> builder = ObjectNode.builder(c, parent);
        if (c.isAnnotationPresent(Style.class)) {
            builder.style(c.getAnnotation(Style.class));
        }
        if (c.isAnnotationPresent(Order.class)) {
            Order order = c.getAnnotation(Order.class);
            builder.order(order);
        }
        if (c.isAnnotationPresent(Comment.class)) {
            Comment comment = c.getAnnotation(Comment.class);
            builder.header(comment);
        }
        for (Field field : c.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!ClassMapper.isValidModifier(modifiers) || field.getName().equals("$self")) continue;
            field.setAccessible(true);
            builder.field(field.getName(), ClassMapper.createFieldNode(field));
            if (!field.isAnnotationPresent(Comment.class)) continue;
            Comment comment = field.getAnnotation(Comment.class);
            builder.comment(field.getName(), comment);
        }
        return builder.build();
    }

    private static Node createFieldNode(Field field) {
        Class<?> type = field.getType();
        if (ClassMapper.isPrimitive(type)) {
            String def = null;
            if (field.isAnnotationPresent(Default.class)) {
                def = field.getAnnotation(Default.class).value();
            }
            return new ValueNode(field, ClassMapper.getParser(type), def);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new MapNode(field);
        }
        if (List.class.isAssignableFrom(type)) {
            return new ListNode(field);
        }
        return ClassMapper.createObjectNode(field.getType(), field);
    }

    private static boolean isValidModifier(int modifier) {
        return !Modifier.isStatic(modifier) && !Modifier.isTransient(modifier);
    }

    private static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || type.isEnum() || PRIMITIVES.containsKey(type);
    }

    private static Function<String, ?> getParser(Class<?> type) {
        if (type.isEnum()) {
            return ClassMapper.enumParser(type);
        }
        return PRIMITIVES.get(type);
    }

    private static Function<String, ?> enumParser(Class<?> type) {
        Object[] values = type.getEnumConstants();
        return s -> {
            for (Object o : values) {
                if (!o.toString().equalsIgnoreCase((String)s)) continue;
                return o;
            }
            return null;
        };
    }
}

