/*
 * Decompiled with CFR 0.152.
 */
package me.dags.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

class ClassUtils {
    ClassUtils() {
    }

    static Constructor<?> getConstructor(Field field, Class<?> def) {
        Constructor<?> constructor;
        if (field != null && (constructor = ClassUtils.getConstructor(field.getType())) != null) {
            return constructor;
        }
        return ClassUtils.getConstructor(def);
    }

    static <T> Constructor<T> getConstructor(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static Type[] getParamTypes(Field field) {
        Type[] args;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType && (args = ((ParameterizedType)type).getActualTypeArguments()).length == 2 && args[0] instanceof Class && args[1] instanceof Class) {
            return args;
        }
        return ClassUtils.getParamTypes(field.getType());
    }

    private static Type[] getParamTypes(Class<?> c) {
        AtomicReference reference = new AtomicReference();
        HashMap<Type, Type> mappings = new HashMap<Type, Type>();
        ClassUtils.populate(c, mappings, reference);
        Class<?> root = reference.get();
        if (root == null) {
            throw new IllegalArgumentException("Could not determine root generic interface");
        }
        TypeVariable<Class<?>>[] params = root.getTypeParameters();
        Type[] types = new Class[params.length];
        for (int i = 0; i < types.length; ++i) {
            Type t = (Type)mappings.get(params[i]);
            if (t == null) {
                throw new IllegalArgumentException("No param type for " + params[i]);
            }
            types[i] = t;
        }
        return types;
    }

    private static void populate(Class<?> c, Map<Type, Type> mappings, AtomicReference<Class<?>> root) {
        if (c == Object.class) {
            return;
        }
        Type type = c.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            root.set(c);
            Class<?> parent = c.getSuperclass();
            Type[] childArgs = ((ParameterizedType)type).getActualTypeArguments();
            TypeVariable<Class<?>>[] parentParams = parent.getTypeParameters();
            for (int i = 0; i < childArgs.length; ++i) {
                Type t = childArgs[i];
                t = mappings.getOrDefault(t, t);
                mappings.put(parentParams[i], t);
            }
        }
        ClassUtils.populate(c.getSuperclass(), mappings, root);
    }
}

