/*
 * Decompiled with CFR 0.152.
 */
package me.dags.config;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.dags.config.ClassMapper;
import me.dags.config.ClassUtils;
import me.dags.config.Node;
import me.dags.config.Render;
import me.dags.config.style.Style;

class ListNode
implements Node {
    static final ListNode EMPTY = new ListNode(null);
    private final Field field;
    private final Node valueTemplate;
    private final Constructor<?> constructor;
    private final Constructor<?> valueConstructor;

    ListNode(Field field) {
        if (field == null) {
            this.field = null;
            this.constructor = null;
            this.valueTemplate = null;
            this.valueConstructor = null;
        } else {
            Constructor constructor;
            Type[] args = ClassUtils.getParamTypes(field);
            Class childType = (Class)args[0];
            this.field = field;
            this.valueTemplate = ClassMapper.getNode(childType);
            try {
                constructor = childType.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                constructor = null;
            }
            this.constructor = ClassUtils.getConstructor(field, ArrayList.class);
            this.valueConstructor = constructor;
        }
    }

    @Override
    public void write(Appendable appendable, Object owner, Style style, int level, boolean key) throws IOException, IllegalAccessException {
        boolean root = level == 0;
        boolean empty = true;
        if (!root) {
            Render.startList(appendable);
        }
        int childLevel = level + 1;
        List list = (List)this.get(owner);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (empty && !root) {
                Render.lineEnd(appendable);
            }
            empty = false;
            Object next = iterator.next();
            Render.indents(appendable, style, level);
            this.valueTemplate.write(appendable, next, style, childLevel, false);
            if (!iterator.hasNext()) continue;
            Render.lineEnd(appendable);
        }
        if (!root) {
            if (empty) {
                Render.endList(appendable);
            } else {
                Render.lineEnd(appendable);
                Render.indents(appendable, style, level - 1);
                Render.endList(appendable);
            }
        }
    }

    public Object newInstance() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.constructor.newInstance(new Object[0]);
    }

    @Override
    public Object get(Object owner) throws IllegalAccessException {
        return this.field.get(owner);
    }

    @Override
    public void set(Object owner, Object value) throws IllegalAccessException {
        this.field.set(owner, value);
    }

    @Override
    public ListNode asList() {
        return this;
    }

    @Override
    public boolean isPresent() {
        return this != EMPTY;
    }

    @Override
    public boolean isEmpty(Object owner) throws IllegalAccessException {
        return ((List)this.get(owner)).isEmpty();
    }

    @Override
    public boolean isList() {
        return true;
    }

    Object newValueInstance() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return this.valueConstructor == null ? null : this.valueConstructor.newInstance(new Object[0]);
    }

    Node getValueTemplate() {
        return this.valueTemplate;
    }

    List getList(Object owner) throws IllegalAccessException {
        return (List)this.get(owner);
    }
}

