/*
 * Decompiled with CFR 0.152.
 */
package me.dags.config;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import me.dags.config.ClassMapper;
import me.dags.config.ClassUtils;
import me.dags.config.Node;
import me.dags.config.Render;
import me.dags.config.style.Style;

class MapNode
implements Node {
    static final MapNode EMPTY = new MapNode();
    private final Field field;
    private final Node keyTemplate;
    private final Node valueTemplate;
    private final Constructor<?> constructor;
    private final Constructor<?> keyConstructor;
    private final Constructor<?> valueConstructor;

    private MapNode() {
        this.field = null;
        this.keyTemplate = null;
        this.valueTemplate = null;
        this.constructor = null;
        this.keyConstructor = null;
        this.valueConstructor = null;
    }

    MapNode(Field field) {
        Constructor valCon;
        Constructor keyCon;
        Type[] args = ClassUtils.getParamTypes(field);
        Class keyType = (Class)args[0];
        Class valType = (Class)args[1];
        this.field = field;
        this.keyTemplate = ClassMapper.getNode(keyType);
        this.valueTemplate = ClassMapper.getNode(valType);
        try {
            keyCon = keyType.getConstructor(new Class[0]);
            keyCon.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            keyCon = null;
        }
        try {
            valCon = valType.getConstructor(new Class[0]);
            valCon.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            valCon = null;
        }
        this.constructor = ClassUtils.getConstructor(field, LinkedHashMap.class);
        this.keyConstructor = keyCon;
        this.valueConstructor = valCon;
    }

    @Override
    public void write(Appendable appendable, Object owner, Style style, int level, boolean key) throws IOException, IllegalAccessException {
        boolean root = level == 0;
        boolean empty = true;
        if (!root) {
            Render.startObject(appendable);
        }
        int childLevel = level + 1;
        Map map = (Map)this.get(owner);
        Iterator iterator = map.entrySet().iterator();
        if (!root && iterator.hasNext()) {
            Render.lineEnd(appendable);
        }
        while (iterator.hasNext()) {
            empty = false;
            Map.Entry field = iterator.next();
            Render.indents(appendable, style, level);
            this.keyTemplate.write(appendable, field.getKey(), style, childLevel, true);
            Render.assign(appendable, style);
            this.valueTemplate.write(appendable, field.getValue(), style, childLevel, false);
            if (!iterator.hasNext()) continue;
            Render.lineEnd(appendable);
        }
        if (!root) {
            if (empty) {
                appendable.append('}');
            } else {
                appendable.append('\n');
                Render.indents(appendable, style, level - 1);
                appendable.append('}');
            }
        }
    }

    public Object newInstance() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return this.constructor.newInstance(new Object[0]);
    }

    @Override
    public Object get(Object owner) throws IllegalAccessException {
        return this.field.get(owner);
    }

    @Override
    public void set(Object owner, Object value) throws IllegalAccessException {
        this.field.set(owner, value);
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public boolean isPresent() {
        return this != EMPTY;
    }

    @Override
    public boolean isEmpty(Object owner) throws IllegalAccessException {
        return ((Map)this.get(owner)).isEmpty();
    }

    @Override
    public MapNode asMap() {
        return this;
    }

    Object newKeyInstance() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return this.keyConstructor == null ? null : this.keyConstructor.newInstance(new Object[0]);
    }

    Object newValueInstance() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return this.valueConstructor == null ? null : this.valueConstructor.newInstance(new Object[0]);
    }

    Node getKeyTemplate() {
        return this.keyTemplate;
    }

    Node getValueTemplate() {
        return this.valueTemplate;
    }

    Map<?, ?> getMap(Object owner) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object value = this.field == null ? this.newInstance() : this.get(owner);
        return (Map)value;
    }

    static Object getSafeKey(Object value) {
        if (value instanceof String) {
            String text = (String)value;
            char box = '\uffff';
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\n') {
                    box = '`';
                    break;
                }
                if (c != ':') continue;
                box = '\'';
            }
            if (box != '\uffff') {
                return box + text + box;
            }
        }
        return value;
    }

    static Object getSafeValue(Object value) {
        if (value instanceof String) {
            String text = (String)value;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c != '\n') continue;
                return '`' + text + '`';
            }
        }
        return value;
    }

    private static Class<?> constructor(Field field) {
        return field == null ? LinkedList.class : field.getType();
    }
}

