/*
 * Decompiled with CFR 0.152.
 */
package me.dags.config;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Supplier;
import me.dags.config.ClassMapper;
import me.dags.config.Node;
import me.dags.config.Parser;
import me.dags.config.style.Style;

public interface Mapper<T> {
    default public void setValue(T owner, Object value, String ... path) {
        try {
            Node node = (Node)this;
            Object parent = owner;
            int end = path.length;
            for (int i = 0; i < end; ++i) {
                if (node.isObject()) {
                    if (i > 0) {
                        parent = node.get(parent);
                    }
                } else {
                    return;
                }
                node = node.asObject().getChild(path[i]);
            }
            if (node.isValue()) {
                node.set(parent, value);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    default public Optional<?> getValue(T owner, String ... path) {
        try {
            Node node = (Node)this;
            Object parent = owner;
            int end = path.length;
            for (int i = 0; i < end; ++i) {
                if (node.isObject()) {
                    if (i > 0) {
                        parent = node.get(parent);
                    }
                } else {
                    return Optional.empty();
                }
                node = node.asObject().getChild(path[i]);
            }
            if (node.isValue()) {
                return Optional.ofNullable(node.get(parent));
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    default public T read(Reader reader) throws Exception {
        Node internal = (Node)this;
        if (internal.isValue()) {
            try (Parser parser = new Parser(reader);){
                T t = parser.unMarshal(null, internal);
                return t;
            }
        }
        try (Parser parser = new Parser(reader);){
            Object t = internal.newInstance();
            Object t2 = parser.unMarshal(t, internal);
            return t2;
        }
    }

    default public T read(InputStream inputStream) throws Exception {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            T t = this.read(reader);
            return t;
        }
    }

    default public T read(File file) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(file);){
            T t = this.read(inputStream);
            return t;
        }
    }

    default public T read(Path path) throws Exception {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            T t = this.read(inputStream);
            return t;
        }
    }

    default public T must(File file, Supplier<T> fallback) {
        T value;
        if (file.exists()) {
            try {
                value = this.read(file);
            }
            catch (Exception e) {
                e.printStackTrace();
                value = fallback.get();
            }
        } else {
            value = fallback.get();
        }
        try {
            this.write(value, file);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return value;
    }

    default public T must(Path path, Supplier<T> fallback) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return this.read(path);
            }
            catch (Exception e) {
                e.printStackTrace();
                return fallback.get();
            }
        }
        T value = fallback.get();
        try {
            this.write(value, path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    default public void write(T object, Writer writer) throws Exception {
        ((Node)this).write(writer, object, Style.DEFAULT, 0, false);
    }

    default public void write(T object, File file) throws Exception {
        file.getAbsoluteFile().getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            this.write(object, writer);
        }
    }

    default public void write(T object, Path path) throws Exception {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.write(object, writer);
        }
    }

    public static <T> Mapper<T> of(Class<T> type) {
        return ClassMapper.getNode(type);
    }
}

