/*
 * Decompiled with CFR 0.152.
 */
package me.dags.config;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.dags.config.ClassUtils;
import me.dags.config.MapNode;
import me.dags.config.Node;
import me.dags.config.Render;
import me.dags.config.ValueNode;
import me.dags.config.style.Comment;
import me.dags.config.style.Order;
import me.dags.config.style.Style;

class ObjectNode<T>
implements Node<T> {
    static final ObjectNode EMPTY = new ObjectNode();
    private final Map<String, Comment> comments;
    private final Map<String, Node> fields;
    private final List<String> order;
    private final Constructor<T> constructor;
    private final Field field;
    private final Style style;

    private ObjectNode() {
        this.comments = Collections.emptyMap();
        this.fields = Collections.emptyMap();
        this.order = Collections.emptyList();
        this.constructor = null;
        this.field = null;
        this.style = Style.DEFAULT;
    }

    private ObjectNode(Builder<T> builder) {
        this.comments = Collections.unmodifiableMap(new HashMap(((Builder)builder).comments));
        this.fields = Collections.unmodifiableMap(new HashMap(((Builder)builder).fields));
        this.order = Collections.unmodifiableList(new LinkedList(((Builder)builder).order));
        this.constructor = ClassUtils.getConstructor(((Builder)builder).type);
        this.field = ((Builder)builder).field;
        this.style = ((Builder)builder).style;
    }

    @Override
    public void write(Appendable appendable, Object owner, Style style, int level, boolean key) throws IOException, IllegalAccessException {
        boolean root;
        boolean bl = root = level == 0;
        if (root || this.style.override()) {
            style = this.style;
        }
        if (!root) {
            Render.startObject(appendable);
        }
        boolean empty = !Render.header(appendable, this.comments.get("#header"), style, level, root);
        int childLevel = level + 1;
        Object instance = this.field != null ? this.get(owner) : owner;
        Collection<String> keys = this.order.isEmpty() ? this.fields.keySet() : this.order;
        for (String next : keys) {
            Node value = this.fields.get(next);
            if (value == null || style.ignoreEmpty() && value.isEmpty(instance)) continue;
            if (empty) {
                if (!root) {
                    Render.lineEnd(appendable);
                }
            } else {
                Render.lineEnd(appendable);
                Render.lineBreaks(appendable, style);
            }
            empty = false;
            Render.comment(appendable, this.comments.get(next), style, level);
            Render.indents(appendable, style, level);
            Render.key(appendable, MapNode.getSafeKey(next), style);
            value.write(appendable, instance, style, childLevel, false);
        }
        if (!root) {
            if (empty) {
                Render.endObject(appendable);
            } else {
                Render.lineEnd(appendable);
                Render.indents(appendable, style, level - 1);
                Render.endObject(appendable);
            }
        }
    }

    @Override
    public T newInstance() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        return this.constructor.newInstance(new Object[0]);
    }

    @Override
    public Object get(Object owner) throws IllegalAccessException {
        if (this.field == null) {
            return null;
        }
        return this.field.get(owner);
    }

    @Override
    public void set(Object owner, Object value) throws IllegalAccessException {
        if (this.field != null) {
            this.field.set(owner, value);
        }
    }

    @Override
    public ObjectNode asObject() {
        return this;
    }

    @Override
    public boolean isPresent() {
        return this != EMPTY;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    Node getChild(String name) {
        return this.fields.getOrDefault(name, ValueNode.EMPTY);
    }

    static <T> Builder<T> builder(Class<T> type, Field field) {
        return new Builder(type, field);
    }

    static class Builder<T> {
        private final Map<String, Comment> comments = new HashMap<String, Comment>();
        private final Map<String, Node> fields = new HashMap<String, Node>();
        private final Set<String> order = new LinkedHashSet<String>();
        private final Class<T> type;
        private final Field field;
        private Style style = Style.DEFAULT;

        private Builder(Class<T> type, Field field) {
            this.type = type;
            this.field = field;
        }

        Builder order(Order order) {
            ArrayList<String> current = new ArrayList<String>(this.order);
            this.order.clear();
            Collections.addAll(this.order, order.value());
            this.order.addAll(current);
            return this;
        }

        Builder style(Style style) {
            this.style = style;
            return this;
        }

        Builder header(Comment comment) {
            this.comments.put("#header", comment);
            return this;
        }

        Builder field(String name, Node template) {
            this.fields.put(name, template);
            this.order.add(name);
            return this;
        }

        Builder comment(String name, Comment comment) {
            this.comments.put(name, comment);
            return this;
        }

        ObjectNode<T> build() {
            return new ObjectNode(this);
        }
    }
}

