/*
 * Decompiled with CFR 0.152.
 */
package me.dags.config;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import me.dags.config.ListNode;
import me.dags.config.MapNode;
import me.dags.config.Node;
import me.dags.config.ObjectNode;
import me.dags.config.Render;
import me.dags.config.ValueNode;

class Parser
implements Closeable {
    private final Reader reader;
    private final char[] buffer = new char[4096];
    private char c = (char)65535;
    private boolean drained = true;

    Parser(Reader reader) {
        this.reader = reader;
    }

    <T> T unMarshal(T owner, Node element) throws Exception {
        return (T)this.parse(owner, element, false);
    }

    private Object parse(Object owner, Node element, boolean key) throws Exception {
        if (element.isObject()) {
            return this.populateObject(owner, element.asObject());
        }
        if (element.isMap()) {
            return this.populateMap(owner, element.asMap());
        }
        if (element.isList()) {
            return this.populateList(owner, element.asList());
        }
        this.skipSpace(false);
        String input = this.nextString(key);
        ValueNode node = element.asValue();
        return node.parse(input);
    }

    private Object populateObject(Object objectOwner, ObjectNode object) throws Exception {
        this.skipComments();
        if (this.peek() == '{') {
            this.consume();
        }
        while (this.next()) {
            this.skipSpace(true);
            if (this.peek() == '}') {
                this.consume();
                break;
            }
            this.skipComments();
            String key = this.nextString(true);
            Node child = object.getChild(key);
            if (!child.isPresent()) continue;
            Object owner = child.isObject() ? child.get(objectOwner) : objectOwner;
            Object value = this.parse(owner, child, false);
            if (!child.isValue() || value == null) continue;
            child.set(owner, value);
        }
        return objectOwner;
    }

    private Map populateMap(Object mapOwner, MapNode map) throws Exception {
        this.skipSpace(false);
        if (this.peek() == '{') {
            this.consume();
        }
        Map<?, ?> instance = map.getMap(mapOwner);
        instance.clear();
        Node keyElement = map.getKeyTemplate();
        Node valueElement = map.getValueTemplate();
        while (this.next()) {
            this.skipSpace(true);
            if (this.peek() == '}') {
                this.consume();
                break;
            }
            Object key = this.parse(map.newKeyInstance(), keyElement, true);
            if (this.peek() == ':') {
                this.consume();
            }
            Object value = this.parse(map.newValueInstance(), valueElement, false);
            instance.put(key, value);
        }
        return instance;
    }

    private List populateList(Object owner, ListNode list) throws Exception {
        this.skipSpace(false);
        if (this.peek() == '[') {
            this.consume();
        }
        List instance = list.getList(owner);
        instance.clear();
        Node node = list.getValueTemplate();
        while (this.next()) {
            this.skipSpace(true);
            if (this.peek() == ']') {
                this.consume();
                break;
            }
            Object value = this.parse(list.newValueInstance(), node, false);
            instance.add(value);
        }
        return instance;
    }

    private boolean next() throws IOException {
        if (this.drained) {
            int i = this.reader.read();
            if (i == -1) {
                return false;
            }
            this.drained = false;
            this.c = (char)i;
        }
        return true;
    }

    private char consume() throws IOException {
        this.drained = true;
        return this.c;
    }

    private char peek() throws IOException {
        if (this.drained) {
            this.next();
        }
        return this.c;
    }

    private void skipSpace(boolean lineBreaks) throws IOException {
        while (this.next()) {
            char c = this.consume();
            if (!lineBreaks && this.isLineBreak(c)) {
                this.drained = false;
                return;
            }
            if (Character.isWhitespace(c)) continue;
            this.drained = false;
            return;
        }
    }

    private void skipComments() throws IOException {
        this.skipSpace(true);
        while (this.peek() == '#') {
            while (this.next()) {
                char c = this.consume();
                if (!this.isLineBreak(c)) continue;
                this.skipComments();
                return;
            }
        }
    }

    private String nextString(boolean key) throws IOException {
        char peek = this.peek();
        if (peek == '`' || peek == '\'') {
            this.consume();
            return this.nextQuotedString(peek);
        }
        return this.nextRawString(key);
    }

    private String nextRawString(boolean key) throws IOException {
        int pos = 0;
        while (this.next()) {
            char c = this.consume();
            if (key && c == ':' || this.isLineBreak(c)) break;
            this.buffer[pos++] = c;
        }
        return new String(this.buffer, 0, pos);
    }

    private String nextQuotedString(char end) throws IOException {
        int pos = 0;
        while (this.next() && this.consume() != end) {
            this.buffer[pos++] = this.c;
        }
        return new String(this.buffer, 0, pos);
    }

    private boolean isLineBreak(char c) {
        return c == '\n' || c == Render.LINE_SEPARATOR;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

