/*
 * Decompiled with CFR 0.152.
 */
package me.dags.config;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.function.Function;
import me.dags.config.MapNode;
import me.dags.config.Node;
import me.dags.config.style.Style;

class ValueNode
implements Node {
    static final ValueNode EMPTY = new ValueNode();
    private final Field field;
    private final Object defaultValue;
    private final Function<String, ?> parser;

    private ValueNode() {
        this.field = null;
        this.parser = null;
        this.defaultValue = null;
    }

    ValueNode(Field field, Function<String, ?> parser, String defaultValue) {
        Object def = null;
        if (parser != null && defaultValue != null) {
            def = parser.apply(defaultValue);
        }
        this.field = field;
        this.parser = parser;
        this.defaultValue = def;
    }

    @Override
    public void write(Appendable appendable, Object owner, Style style, int level, boolean key) throws IOException, IllegalAccessException {
        Object value = this.field == null ? owner : this.get(owner);
        Object safe = key ? MapNode.getSafeKey(value) : MapNode.getSafeValue(value);
        appendable.append(safe.toString());
    }

    @Override
    public ValueNode asValue() {
        return this;
    }

    @Override
    public boolean isPresent() {
        return this != EMPTY;
    }

    @Override
    public boolean isEmpty(Object owner) throws IllegalAccessException {
        Object value;
        if (owner != null && this.field != null && (value = this.get(owner)) != null) {
            return this.defaultValue != null && value.equals(this.defaultValue);
        }
        return true;
    }

    @Override
    public boolean isValue() {
        return true;
    }

    public Object newInstance() throws IllegalAccessException, InstantiationException {
        return null;
    }

    @Override
    public Object get(Object owner) throws IllegalAccessException {
        return this.field != null ? this.field.get(owner) : null;
    }

    @Override
    public void set(Object owner, Object value) throws IllegalAccessException {
        if (this.field == null || owner == null) {
            return;
        }
        this.field.set(owner, value);
    }

    Object parse(String input) {
        return this.parser != null ? this.parser.apply(input) : null;
    }
}

