/*
 * Decompiled with CFR 0.152.
 */
package me.dags.http.client;

import java.io.IOException;
import me.dags.http.client.FormBody;
import me.dags.http.client.HttpUrl;
import me.dags.http.client.MultipartBody;
import me.dags.http.client.OkHttpClient;
import me.dags.http.client.Request;
import me.dags.http.client.RequestBody;
import me.dags.http.client.Response;
import me.dags.http.client.ResponseBody;
import me.dags.http.json.JsonNode;
import me.dags.http.json.JsonParser;

public final class Client {
    private static final OkHttpClient client = new OkHttpClient();

    private Client() {
    }

    public static HttpUrl.Builder url(String url) {
        HttpUrl parsed = HttpUrl.parse(url);
        if (parsed == null) {
            return new HttpUrl.Builder();
        }
        return parsed.newBuilder();
    }

    public static Response execute(Request request) throws IOException {
        return client.newCall(request).execute();
    }

    public static Response get(String url) throws IOException {
        return Client.execute(Client.request(url).get().build());
    }

    public static Response get(HttpUrl url) throws IOException {
        return Client.execute(Client.request(url).get().build());
    }

    public static Response post(HttpUrl url, RequestBody body) throws IOException {
        return Client.execute(Client.request(url).post(body).build());
    }

    public static Request.Builder request(String url) {
        return Client.request(Client.url(url).build());
    }

    public static Request.Builder request(HttpUrl url) {
        return new Request.Builder().url(url);
    }

    public static MultipartBody.Builder multipart() {
        return new MultipartBody.Builder();
    }

    public static FormBody.Builder form() {
        return new FormBody.Builder();
    }

    public static JsonNode json(Request request) throws IOException {
        Response response = Client.execute(request);
        return Client.parseJson(response);
    }

    public static JsonNode parseJson(Response response) {
        ResponseBody body = response.body();
        if (body == null) {
            return JsonNode.NULL;
        }
        return new JsonParser(body.charStream()).parse();
    }
}

